/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.validation.ui;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.javaee.validation.ui.ConstraintType;
import org.jboss.forge.addon.parser.java.beans.Property;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.ui.InputComponentFactory;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.facets.HintsFacet;
import org.jboss.forge.addon.ui.hints.InputType;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.ManyValued;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.util.Assert;
import org.jboss.forge.parser.java.util.Strings;

public class GenerateConstraintWizardStep
extends AbstractJavaEECommand
implements UIWizardStep {
    @Inject
    private InputComponentFactory factory;
    @Inject
    private ConverterFactory converterFactory;
    private Map<String, InputComponent<?, ?>> inputs = new HashMap();

    public NavigationResult next(UIContext context) throws Exception {
        return null;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        UIContext context = builder.getUIContext();
        ConstraintType constraintType = (ConstraintType)context.getAttribute(ConstraintType.class);
        this.generateConstraintInputs(builder, constraintType.getConstraint());
    }

    private void generateConstraintInputs(UIBuilder builder, Class<? extends java.lang.annotation.Annotation> constraint) {
        for (Method m : constraint.getDeclaredMethods()) {
            UIInputMany inputComponent;
            String name = m.getName();
            Class<?> valueType = m.getReturnType();
            boolean many = valueType.isArray();
            if (many) {
                valueType = valueType.getComponentType();
            }
            if (valueType.isEnum()) {
                Object select = many ? this.factory.createSelectMany(name, valueType) : this.factory.createSelectOne(name, valueType);
                Class<Enum> enumClass = valueType.asSubclass(Enum.class);
                select.setValueChoices(EnumSet.allOf(enumClass));
                inputComponent = select;
            } else {
                Object input = many ? this.factory.createInputMany(name, String.class) : this.factory.createInput(name, this.calculateType(valueType));
                if (valueType == Class.class) {
                    HintsFacet facet = (HintsFacet)input.getFacet(HintsFacet.class);
                    facet.setInputType(InputType.JAVA_CLASS_PICKER);
                }
                inputComponent = input;
            }
            try {
                List<Object> defaultValue = m.getDefaultValue();
                if (defaultValue != null) {
                    if (many) {
                        List<Object> defaultValues;
                        defaultValue = defaultValues = this.toList(valueType, defaultValue);
                    }
                    InputComponents.setDefaultValueFor((ConverterFactory)this.converterFactory, (InputComponent)inputComponent, (Object)defaultValue);
                } else {
                    inputComponent.setRequired(true);
                }
            }
            catch (TypeNotPresentException tnpe) {
                inputComponent.setRequired(true);
            }
            builder.add((InputComponent)inputComponent);
            this.inputs.put(name, (InputComponent<?, ?>)inputComponent);
        }
    }

    private List<Object> toList(Class<?> valueType, Object arrayObject) {
        ArrayList<Object> defaultValues = new ArrayList<Object>();
        int length = Array.getLength(arrayObject);
        boolean isClassType = valueType == Class.class;
        for (int i = 0; i < length; ++i) {
            Object arrayValue = Array.get(arrayObject, i);
            if (isClassType) {
                arrayValue = ((Class)arrayValue).getName();
            }
            defaultValues.add(arrayValue);
        }
        return defaultValues;
    }

    private Class<?> calculateType(Class<?> valueType) {
        if (valueType == Integer.TYPE) {
            return Integer.class;
        }
        if (valueType == Long.TYPE) {
            return Long.class;
        }
        return valueType;
    }

    public Result execute(UIContext context) throws Exception {
        Property property = (Property)context.getAttribute(Property.class);
        ConstraintType constraintType = (ConstraintType)context.getAttribute(ConstraintType.class);
        Boolean onAccessor = (Boolean)context.getAttribute((Object)"onAccessor");
        Object annotationTarget = onAccessor != false ? property.getAccessor() : property.getActualField();
        Class<? extends java.lang.annotation.Annotation> constraintAnnotation = constraintType.getConstraint();
        Annotation annotation = annotationTarget.addAnnotation(constraintAnnotation);
        this.populateAnnotation(constraintAnnotation, (Annotation<JavaClass>)annotation);
        ((JavaSourceFacet)this.getSelectedProject(context).getFacet(JavaSourceFacet.class)).saveJavaSource((JavaSource)annotation.getOrigin());
        return Results.success((String)("Constraint " + constraintAnnotation.getSimpleName() + " successfully configured"));
    }

    private void populateAnnotation(Class<? extends java.lang.annotation.Annotation> constraint, Annotation<JavaClass> annotation) {
        for (Method m : constraint.getDeclaredMethods()) {
            String name = m.getName();
            Class<?> returnType = m.getReturnType();
            InputComponent<?, ?> inputComponent = this.inputs.get(name);
            Object componentValue = InputComponents.getValueFor(inputComponent);
            if (componentValue == null) continue;
            try {
                Class<?> componentType;
                List<Object> defaultValues;
                Collection values;
                Object defaultValue = m.getDefaultValue();
                if (defaultValue != null && (returnType.isArray() ? (values = (Collection)componentValue).containsAll(defaultValues = this.toList(componentType = returnType.getComponentType(), defaultValue)) : returnType == Class.class && ((Class)defaultValue).getName().equals(componentValue) || componentValue.toString().equals(defaultValue.toString()))) {
                    continue;
                }
            }
            catch (TypeNotPresentException tnpe) {
                // empty catch block
            }
            if (inputComponent instanceof ManyValued) {
                returnType = returnType.getComponentType();
                Collection values = (Collection)componentValue;
                this.setArrayValue(annotation, name, returnType, values, returnType == Class.class);
                continue;
            }
            if (returnType == Class.class) {
                annotation.setLiteralValue(name, componentValue + ".class");
                continue;
            }
            if (returnType == String.class) {
                annotation.setStringValue(name, componentValue.toString());
                continue;
            }
            annotation.setLiteralValue(name, componentValue.toString());
        }
    }

    private void setArrayValue(Annotation<JavaClass> annotation, String name, Class<?> type, Iterable<Object> values, boolean isClass) {
        Assert.notNull(values, (String)"null array not accepted");
        ArrayList<String> literals = new ArrayList<String>();
        for (Object value : values) {
            Assert.notNull((Object)value, (String)"null value not accepted");
            if (!type.isPrimitive()) {
                ((JavaClass)annotation.getOrigin()).addImport(type);
            }
            literals.add(value + (isClass ? ".class" : ""));
        }
        if (!literals.isEmpty()) {
            annotation.setLiteralValue(name, literals.size() == 1 ? (String)literals.get(0) : String.format("{%s}", Strings.join(literals, (String)",")));
        }
    }

    protected boolean isProjectRequired() {
        return false;
    }
}

