/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.validation.ui;

import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.javaee.validation.ConstraintOperations;
import org.jboss.forge.addon.javaee.validation.ui.ConstraintType;
import org.jboss.forge.addon.javaee.validation.ui.CoreConstraints;
import org.jboss.forge.addon.javaee.validation.ui.GenerateConstraintWizardStep;
import org.jboss.forge.addon.parser.java.beans.JavaClassIntrospector;
import org.jboss.forge.addon.parser.java.beans.Property;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.hints.InputType;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.forge.parser.java.JavaClass;

public class SelectFieldWizardStep
extends AbstractJavaEECommand
implements UIWizardStep {
    @Inject
    @WithAttributes(label="Property", description="The property on which the constraint applies", required=true, type=InputType.DROPDOWN)
    private UISelectOne<Property> property;
    @Inject
    @WithAttributes(label="Constraint", description="The type of constraint to add", required=true, type=InputType.DROPDOWN)
    private UISelectOne<CoreConstraints> constraint;
    @Inject
    @WithAttributes(label="Add constraint on the property accessor?")
    private UIInput<Boolean> onAccessor;
    @Inject
    private ConstraintOperations constraintOperations;

    public void initializeUI(UIBuilder builder) throws Exception {
        this.setupProperty(builder.getUIContext());
        this.setupConstraint();
        this.setupAccessor();
        builder.add(this.property).add(this.constraint).add(this.onAccessor);
    }

    private void setupProperty(UIContext context) throws Exception {
        JavaResource selectedResource = (JavaResource)context.getAttribute(JavaResource.class);
        JavaClass javaClass = (JavaClass)selectedResource.getJavaSource();
        JavaClassIntrospector introspector = new JavaClassIntrospector(javaClass);
        this.property.setItemLabelConverter((Converter)new Converter<Property, String>(){

            public String convert(Property source) {
                return source == null ? null : source.getName();
            }
        });
        List properties = introspector.getProperties();
        this.property.setValueChoices((Iterable)properties);
    }

    private void setupConstraint() {
        this.constraint.setItemLabelConverter((Converter)new Converter<CoreConstraints, String>(){

            public String convert(CoreConstraints source) {
                return source == null ? null : source.getDescription();
            }
        });
        this.constraint.setValueChoices(EnumSet.allOf(CoreConstraints.class));
    }

    private void setupAccessor() {
        this.onAccessor.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ((Property)SelectFieldWizardStep.this.property.getValue()).isReadable();
            }
        });
    }

    public Result execute(UIContext context) throws Exception {
        ConstraintType constraintType = (ConstraintType)this.constraint.getValue();
        if (constraintType == CoreConstraints.VALID) {
            Project project = this.getSelectedProject(context);
            Result result = this.constraintOperations.addValidConstraint(project, (Property)this.property.getValue(), (Boolean)this.onAccessor.getValue());
            return result;
        }
        return Results.success();
    }

    public NavigationResult next(UIContext context) throws Exception {
        ConstraintType constraintType = (ConstraintType)this.constraint.getValue();
        context.setAttribute(Property.class, this.property.getValue());
        context.setAttribute(ConstraintType.class, (Object)constraintType);
        context.setAttribute((Object)"onAccessor", this.onAccessor.getValue());
        if (constraintType == CoreConstraints.VALID) {
            return null;
        }
        return Results.navigateTo(GenerateConstraintWizardStep.class);
    }

    protected boolean isProjectRequired() {
        return false;
    }
}

