/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.validation.ui.setup;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.javaee.validation.ValidationOperations;
import org.jboss.forge.addon.javaee.validation.provider.ValidationProvider;
import org.jboss.forge.addon.javaee.validation.providers.JavaEEValidatorProvider;
import org.jboss.forge.addon.javaee.validation.ui.setup.ClassInputValidator;
import org.jboss.forge.addon.ui.UICommand;
import org.jboss.forge.addon.ui.UIValidator;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.hints.InputType;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class ValidationProviderSetupCommand
extends AbstractJavaEECommand
implements UICommand {
    @Inject
    @WithAttributes(label="Bean Validation provider", required=true)
    private UISelectOne<ValidationProvider> providers;
    @Inject
    @WithAttributes(label="Provided by Application Server?")
    private UIInput<Boolean> providedScope;
    @Inject
    @WithAttributes(label="Message Interpolator Class", type=InputType.JAVA_CLASS_PICKER)
    private UIInput<String> messageInterpolator;
    @Inject
    @WithAttributes(label="Traversable Resolver Class", type=InputType.JAVA_CLASS_PICKER)
    private UIInput<String> traversableResolver;
    @Inject
    @WithAttributes(label="Constraint Validator Factory Class", type=InputType.JAVA_CLASS_PICKER)
    private UIInput<String> constraintValidatorFactory;
    @Inject
    private JavaEEValidatorProvider defaultProvider;
    @Inject
    private ValidationOperations validationOperations;

    public Metadata getMetadata(UIContext context) {
        Metadata metadata = Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass());
        return metadata.name("Bean Validation: Setup").description("Setup Bean Validation in your project").category(Categories.create((String[])new String[]{metadata.getCategory().getName(), "Bean Validation"}));
    }

    public boolean isEnabled(UIContext context) {
        return this.containsProject(context);
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.initProviders();
        this.messageInterpolator.setValidator((UIValidator)new ClassInputValidator(this.messageInterpolator));
        this.traversableResolver.setValidator((UIValidator)new ClassInputValidator(this.traversableResolver));
        this.constraintValidatorFactory.setValidator((UIValidator)new ClassInputValidator(this.constraintValidatorFactory));
        this.providedScope.setDefaultValue((Object)true);
        Callable<Boolean> dependencyNotProvided = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return (Boolean)ValidationProviderSetupCommand.this.providedScope.getValue() == false;
            }
        };
        this.messageInterpolator.setEnabled((Callable)dependencyNotProvided);
        this.traversableResolver.setEnabled((Callable)dependencyNotProvided);
        this.constraintValidatorFactory.setEnabled((Callable)dependencyNotProvided);
        builder.add(this.providers).add(this.providedScope).add(this.messageInterpolator).add(this.traversableResolver).add(this.constraintValidatorFactory);
    }

    public void validate(UIValidationContext validator) {
        super.validate(validator);
    }

    public Result execute(UIContext context) throws Exception {
        this.validationOperations.setup(this.getSelectedProject(context), (ValidationProvider)this.providers.getValue(), (Boolean)this.providedScope.getValue(), (String)this.messageInterpolator.getValue(), (String)this.traversableResolver.getValue(), (String)this.constraintValidatorFactory.getValue());
        return Results.success((String)"Bean Validation is installed.");
    }

    private void initProviders() {
        this.providers.setItemLabelConverter((Converter)new Converter<ValidationProvider, String>(){

            public String convert(ValidationProvider source) {
                return source != null ? source.getName() : null;
            }
        });
        this.providers.setDefaultValue((Object)this.defaultProvider);
    }

    protected boolean isProjectRequired() {
        return true;
    }
}

