/*
 * Copyright 2013 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Eclipse Public License version 1.0, available at
 * http://www.eclipse.org/legal/epl-v10.html
 */

package org.jboss.forge.addon.javaee.servlet;

import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.inject.Inject;

import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.javaee.Descriptors;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.furnace.util.Streams;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImporter;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;

public class ServletFacetImpl_3_0 extends AbstractServletFacet<WebAppDescriptor> implements ServletFacet_3_0
{
   private static final Dependency JAVAX_SERVLET_API = DependencyBuilder
            .create("org.jboss.spec.javax.servlet:jboss-servlet-api_3.0_spec");

   @Inject
   public ServletFacetImpl_3_0(DependencyInstaller installer)
   {
      super(installer);
   }

   @Override
   public Version getSpecVersion()
   {
      return new SingleVersion("3.0");
   }

   @Override
   protected Map<Dependency, List<Dependency>> getRequiredDependencyOptions()
   {
      Map<Dependency, List<Dependency>> map = new LinkedHashMap<>();
      map.put(JAVAX_SERVLET_API, Arrays.asList(JAVAX_SERVLET_API));
      return map;
   }

   /*
    * Facet Methods
    */
   @Override
   public WebAppDescriptor getConfig()
   {
      FileResource<?> configFile = getConfigFile();
      WebAppDescriptor descriptor;
      if (configFile.exists())
      {

         DescriptorImporter<WebAppDescriptor> importer = Descriptors.importAs(WebAppDescriptor.class);
         InputStream inputStream = configFile.getResourceInputStream();
         try
         {
            descriptor = importer.fromStream(inputStream);
         }
         finally
         {
            Streams.closeQuietly(inputStream);
         }
      }
      else
      {
         descriptor = Descriptors.create(WebAppDescriptor.class);
         String projectName = getFaceted().getFacet(MetadataFacet.class).getProjectName();
         WebAppDescriptor unit = descriptor
                  .version("3.0")
                  .displayName(projectName)
                  .createSessionConfig()
                  .sessionTimeout(30).up();
         // FORGE-657
         unit.createMimeMapping().extension("ico").mimeType("image/x-icon");
      }
      return descriptor;
   }

   @Override
   public void saveConfig(final WebAppDescriptor descriptor)
   {
      FileResource<?> configFile = getConfigFile();
      String output = descriptor.exportAsString();
      configFile.setContents(output);
   }
}