/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.cdi;

import java.io.File;
import javax.inject.Inject;
import org.jboss.forge.addon.javaee.AbstractJavaEEFacet;
import org.jboss.forge.addon.javaee.Descriptors;
import org.jboss.forge.addon.javaee.cdi.CDIFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImporter;

public abstract class AbstractCDIFacetImpl<DESCRIPTOR extends Descriptor>
extends AbstractJavaEEFacet
implements CDIFacet<DESCRIPTOR> {
    @Inject
    public AbstractCDIFacetImpl(DependencyInstaller installer) {
        super(installer);
    }

    public String getSpecName() {
        return "CDI";
    }

    protected abstract String getDescriptorContent();

    protected abstract Class<DESCRIPTOR> getDescriptorType();

    @Override
    public boolean install() {
        FileResource<?> descriptor;
        if (!this.isInstalled() && !(descriptor = this.getConfigFile()).exists()) {
            if (!descriptor.createNewFile()) {
                throw new RuntimeException("Failed to create required [" + descriptor.getFullyQualifiedName() + "]");
            }
            String data = this.getDescriptorContent();
            descriptor.setContents(data);
        }
        return super.install();
    }

    @Override
    public boolean isInstalled() {
        return this.getConfigFile().exists() && super.isInstalled();
    }

    public DESCRIPTOR getConfig() {
        DescriptorImporter importer = Descriptors.importAs(this.getDescriptorType());
        Descriptor descriptor = importer.fromStream(this.getConfigFile().getResourceInputStream());
        return (DESCRIPTOR)descriptor;
    }

    public void saveConfig(DESCRIPTOR model) {
        String output = model.exportAsString();
        this.getConfigFile().setContents(output);
    }

    public FileResource<?> getConfigFile() {
        Project project = (Project)this.getFaceted();
        PackagingFacet packaging = (PackagingFacet)project.getFacet(PackagingFacet.class);
        if ("war".equals(packaging.getPackagingType())) {
            DirectoryResource webRoot = ((WebResourcesFacet)project.getFacet(WebResourcesFacet.class)).getWebRootDirectory();
            return (FileResource)webRoot.getChild("WEB-INF" + File.separator + "beans.xml");
        }
        DirectoryResource root = ((ResourcesFacet)project.getFacet(ResourcesFacet.class)).getResourceDirectory();
        return (FileResource)root.getChild("META-INF" + File.separator + "beans.xml");
    }
}

