/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.cdi.ui;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.forge.addon.javaee.cdi.CDIFacet;
import org.jboss.forge.addon.javaee.cdi.CDIOperations;
import org.jboss.forge.addon.javaee.cdi.ui.CDISetupCommand;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.parser.java.beans.ProjectOperations;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.command.PrerequisiteCommandsProvider;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICategory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.ParameterSource;

public class CDIAddObserverMethodCommand
extends AbstractJavaEECommand
implements PrerequisiteCommandsProvider {
    @Inject
    @WithAttributes(label="Target Class", description="The class where the method will be created", required=true, type="org.jboss.forge.inputType.DROPDOWN")
    private UISelectOne<JavaResource> targetClass;
    @Inject
    @WithAttributes(label="Method Name", description="The name of the created method", required=true)
    private UIInput<String> named;
    @Inject
    @WithAttributes(label="Event Type", description="The event type of the created method", type="org.jboss.forge.inputType.JAVA_CLASS_PICKER", required=true)
    private UIInput<String> eventType;
    @Inject
    @WithAttributes(label="Qualifiers", description="The qualifiers added to the injection point", type="org.jboss.forge.inputType.JAVA_CLASS_PICKER")
    private UIInputMany<String> qualifiers;
    @Inject
    private ProjectOperations projectOperations;
    @Inject
    private CDIOperations cdiOperations;

    public void initializeUI(UIBuilder builder) throws Exception {
        UIContext uiContext = builder.getUIContext();
        Project project = this.getSelectedProject(uiContext);
        this.setupTargetClass(uiContext, project);
        this.setupType();
        this.setupQualifiers();
        builder.add(this.targetClass).add(this.named).add(this.eventType).add(this.qualifiers);
    }

    private void setupTargetClass(UIContext uiContext, Project project) {
        UISelection resource = uiContext.getInitialSelection();
        if (resource.get() instanceof JavaResource) {
            this.targetClass.setDefaultValue((Object)((JavaResource)resource.get()));
        }
        this.targetClass.setValueChoices((Iterable)this.projectOperations.getProjectClasses(project));
    }

    private void setupQualifiers() {
        this.qualifiers.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                Project project = CDIAddObserverMethodCommand.this.getSelectedProject(context);
                ArrayList<String> options = new ArrayList<String>();
                for (String type : CDIOperations.DEFAULT_QUALIFIERS) {
                    if (!Strings.isNullOrEmpty((String)value) && !type.startsWith(value)) continue;
                    options.add(type);
                }
                if (project != null) {
                    for (JavaResource resource : CDIAddObserverMethodCommand.this.cdiOperations.getProjectQualifiers(project)) {
                        try {
                            JavaSource javaSource = (JavaSource)resource.getJavaType();
                            String qualifiedName = javaSource.getQualifiedName();
                            if (!Strings.isNullOrEmpty((String)value) && !qualifiedName.startsWith(value)) continue;
                            options.add(qualifiedName);
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                    }
                }
                return options;
            }
        });
    }

    private void setupType() {
        this.eventType.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                Project project = CDIAddObserverMethodCommand.this.getSelectedProject(context);
                ArrayList<String> options = new ArrayList<String>();
                if (project != null) {
                    for (JavaResource resource : CDIAddObserverMethodCommand.this.cdiOperations.getProjectEventTypes(project)) {
                        try {
                            JavaSource javaSource = (JavaSource)resource.getJavaType();
                            String qualifiedName = javaSource.getQualifiedName();
                            if (!Strings.isNullOrEmpty((String)value) && !qualifiedName.startsWith(value)) continue;
                            options.add(qualifiedName);
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                    }
                }
                return options;
            }
        });
    }

    protected boolean isProjectRequired() {
        return true;
    }

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("CDI: Add Observer Method").description("Adds a new observer method to a bean").category(Categories.create((UICategory)Categories.create((String[])new String[]{"Java EE"}), (String[])new String[]{"CDI"}));
    }

    public void validate(UIValidationContext validator) {
        JavaResource javaResource = (JavaResource)this.targetClass.getValue();
        if (javaResource != null && javaResource.exists()) {
            try {
                JavaClassSource javaClass = (JavaClassSource)javaResource.getJavaType();
                if (javaClass.hasMethodSignature((String)this.named.getValue(), new String[]{(String)this.eventType.getValue()})) {
                    validator.addValidationError(this.named, "Method signature already exists");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public NavigationResult getPrerequisiteCommands(UIContext context) {
        NavigationResultBuilder builder = NavigationResultBuilder.create();
        Project project = this.getSelectedProject(context);
        if (project != null && !project.hasFacet(CDIFacet.class)) {
            builder.add(CDISetupCommand.class);
        }
        return builder.build();
    }

    public Result execute(UIExecutionContext context) throws Exception {
        JavaResource javaResource = (JavaResource)this.targetClass.getValue();
        JavaClassSource javaClass = (JavaClassSource)javaResource.getJavaType();
        ParameterSource parameter = ((MethodSource)((MethodSource)javaClass.addMethod().setPublic()).setReturnTypeVoid().setName((String)this.named.getValue())).setBody("").addParameter((String)this.eventType.getValue(), "event");
        parameter.addAnnotation(Observes.class);
        for (String qualifier : this.qualifiers.getValue()) {
            parameter.addAnnotation(qualifier);
        }
        javaResource.setContents((JavaSource)javaClass);
        return Results.success();
    }
}

