/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.cdi.ui;

import java.util.concurrent.Callable;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.forge.addon.javaee.cdi.ui.AbstractCDICommand;
import org.jboss.forge.addon.javaee.cdi.ui.BeanScope;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.roaster.model.source.JavaClassSource;

public class CDINewBeanCommand
extends AbstractCDICommand<JavaClassSource> {
    @Inject
    @WithAttributes(label="Scope", defaultValue="DEPENDENT")
    private UISelectOne<BeanScope> scoped;
    @Inject
    @WithAttributes(label="Custom Scope Annotation", type="org.jboss.forge.inputType.JAVA_CLASS_PICKER")
    private UIInput<String> customScopeAnnotation;
    @Inject
    @WithAttributes(label="Qualifier")
    private UIInput<String> qualifier;
    @Inject
    @WithAttributes(label="Alternative")
    private UIInput<Boolean> alternative;
    @Inject
    @WithAttributes(label="Named")
    private UIInput<Boolean> withNamed;

    @Override
    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("CDI: New Bean").description("Creates a new CDI Managed bean");
    }

    protected String getType() {
        return "CDI Bean";
    }

    protected Class<JavaClassSource> getSourceType() {
        return JavaClassSource.class;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        Callable<Boolean> customScopeSelected = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return CDINewBeanCommand.this.scoped.getValue() == BeanScope.CUSTOM;
            }
        };
        ((UIInput)this.customScopeAnnotation.setEnabled((Callable)customScopeSelected)).setRequired((Callable)customScopeSelected);
        builder.add(this.scoped).add(this.customScopeAnnotation).add(this.qualifier).add(this.alternative).add(this.withNamed);
    }

    public JavaClassSource decorateSource(UIExecutionContext context, Project project, JavaClassSource source) throws Exception {
        BeanScope scopedValue = (BeanScope)((Object)this.scoped.getValue());
        if (BeanScope.CUSTOM == scopedValue) {
            source.addAnnotation((String)this.customScopeAnnotation.getValue());
        } else if (BeanScope.DEPENDENT != scopedValue) {
            source.addAnnotation(scopedValue.getAnnotation());
        }
        if (((Boolean)this.withNamed.getValue()).booleanValue()) {
            source.addAnnotation(Named.class);
        }
        if (((Boolean)this.alternative.getValue()).booleanValue()) {
            source.addAnnotation(Alternative.class);
        }
        if (this.qualifier != null && this.qualifier.getValue() != null && !"".equals(this.qualifier.getValue())) {
            source.addAnnotation((String)this.qualifier.getValue());
        }
        return source;
    }
}

