/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.cdi.ui;

import java.io.FileNotFoundException;
import javax.enterprise.context.Conversation;
import javax.inject.Inject;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.roaster.model.Field;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.Method;
import org.jboss.forge.roaster.model.SyntaxError;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class CDINewConversationCommand
extends AbstractUICommand {
    @Inject
    @WithAttributes(label="Named", defaultValue="")
    private UIInput<String> named;
    @Inject
    @WithAttributes(label="Conversation Field Name", defaultValue="conversation", required=true)
    private UIInput<String> conversationFieldName;
    @Inject
    @WithAttributes(label="Timeout")
    private UIInput<Long> timeout;
    @Inject
    @WithAttributes(label="Begin Method Name", defaultValue="beginConversation", required=true)
    private UIInput<String> beginMethodName;
    @Inject
    @WithAttributes(label="End Method Name", defaultValue="endConversation", required=true)
    private UIInput<String> endMethodName;
    @Inject
    @WithAttributes(label="Overwrite")
    private UIInput<Boolean> overwrite;

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.named).add(this.timeout).add(this.conversationFieldName).add(this.beginMethodName).add(this.endMethodName).add(this.overwrite);
    }

    public void validate(UIValidationContext validator) {
        boolean overwriteValue = this.overwrite.getValue() != null && (Boolean)this.overwrite.getValue() != false;
        JavaResource resource = (JavaResource)validator.getUIContext().getInitialSelection().get();
        if (!overwriteValue) {
            try {
                String fieldName = (String)this.conversationFieldName.getValue();
                String beginName = (String)this.beginMethodName.getValue();
                String endName = (String)this.endMethodName.getValue();
                JavaClassSource javaClass = (JavaClassSource)resource.getJavaType();
                if (javaClass.hasField(fieldName) && !javaClass.getField(fieldName).getType().isType(Conversation.class)) {
                    validator.addValidationError(this.conversationFieldName, "Field [" + fieldName + "] already exists.");
                }
                if (javaClass.hasMethodSignature(beginName) && javaClass.getMethod(beginName).getParameters().size() == 0) {
                    validator.addValidationError(this.beginMethodName, "Method [" + beginName + "] exists.");
                }
                if (javaClass.hasMethodSignature(endName) && javaClass.getMethod(endName).getParameters().size() == 0) {
                    validator.addValidationError(this.endMethodName, "Method [" + endName + "] exists.");
                }
            }
            catch (FileNotFoundException e) {
                validator.addValidationError(null, "The selected resource file was not found");
            }
        }
    }

    public Result execute(UIExecutionContext context) throws Exception {
        UIContext uiContext = context.getUIContext();
        JavaResource resource = (JavaResource)uiContext.getInitialSelection().get();
        String name = (String)this.named.getValue();
        String fieldName = (String)this.conversationFieldName.getValue();
        String beginName = (String)this.beginMethodName.getValue();
        String endName = (String)this.endMethodName.getValue();
        Boolean overwriteValue = (Boolean)this.overwrite.getValue();
        UIOutput output = uiContext.getProvider().getOutput();
        if (resource.exists()) {
            JavaType javaType = resource.getJavaType();
            if (javaType.isClass()) {
                JavaClassSource javaClass = (JavaClassSource)javaType;
                if (javaClass.hasField(fieldName) && !javaClass.getField(fieldName).getType().isType(Conversation.class)) {
                    if (overwriteValue.booleanValue()) {
                        javaClass.removeField((Field)javaClass.getField(fieldName));
                    } else {
                        return Results.fail((String)("Field [" + fieldName + "] already exists."));
                    }
                }
                if (javaClass.hasMethodSignature(beginName) && javaClass.getMethod(beginName).getParameters().size() == 0) {
                    if (overwriteValue.booleanValue()) {
                        javaClass.removeMethod((Method)javaClass.getMethod(beginName));
                    } else {
                        return Results.fail((String)("Method [" + beginName + "] exists."));
                    }
                }
                if (javaClass.hasMethodSignature(endName) && javaClass.getMethod(endName).getParameters().size() == 0) {
                    if (overwriteValue.booleanValue()) {
                        javaClass.removeMethod((Method)javaClass.getMethod(endName));
                    } else {
                        return Results.fail((String)("Method [" + endName + "] exists."));
                    }
                }
                ((FieldSource)((FieldSource)javaClass.addField().setPrivate()).setName(fieldName)).setType(Conversation.class).addAnnotation(Inject.class);
                MethodSource beginMethod = (MethodSource)((MethodSource)javaClass.addMethod().setName(beginName)).setReturnTypeVoid().setPublic();
                if (Strings.isNullOrEmpty((String)name)) {
                    beginMethod.setBody(fieldName + ".begin();");
                } else {
                    beginMethod.setBody(fieldName + ".begin(\"" + name + "\");");
                }
                if (this.timeout.getValue() != null) {
                    beginMethod.setBody(beginMethod.getBody() + "\n" + fieldName + ".setTimeout(" + this.timeout + ");");
                }
                ((MethodSource)((MethodSource)javaClass.addMethod().setName(endName)).setReturnTypeVoid().setPublic()).setBody(fieldName + ".end();");
                if (javaClass.hasSyntaxErrors()) {
                    output.err().println("Modified Java class contains syntax errors:");
                    for (SyntaxError error : javaClass.getSyntaxErrors()) {
                        output.err().print(error.getDescription());
                    }
                }
                resource.setContents((JavaSource)javaClass);
            } else {
                return Results.fail((String)"Must operate on a Java Class file");
            }
        }
        return Results.success((String)"Conversation block created");
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("CDI: New Conversation").description("Creates a conversation block in the specified method").category(Categories.create((String[])new String[]{"Java EE", "CDI"}));
    }

    public boolean isEnabled(UIContext context) {
        boolean result;
        UISelection initialSelection = context.getInitialSelection();
        if (initialSelection.isEmpty()) {
            result = false;
        } else {
            Object selection = initialSelection.get();
            if (selection instanceof JavaResource) {
                try {
                    result = ((JavaResource)selection).getJavaType().isClass();
                }
                catch (FileNotFoundException e) {
                    result = false;
                }
            } else {
                result = false;
            }
        }
        return result;
    }
}

