/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.cdi.ui;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.enterprise.context.NormalScope;
import javax.inject.Inject;
import javax.inject.Scope;
import org.jboss.forge.addon.javaee.cdi.ui.AbstractCDICommand;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.JavaAnnotationSource;

public class CDINewScopeCommand
extends AbstractCDICommand<JavaAnnotationSource> {
    @Inject
    @WithAttributes(label="Pseudo Scope")
    private UIInput<Boolean> pseudo;
    @Inject
    @WithAttributes(label="Passivating")
    private UIInput<Boolean> passivating;

    @Override
    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("CDI: New Scope").description("Creates a new CDI Scope annotation");
    }

    protected String getType() {
        return "CDI Scope";
    }

    protected Class<JavaAnnotationSource> getSourceType() {
        return JavaAnnotationSource.class;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        builder.add(this.pseudo).add(this.passivating);
    }

    public void validate(UIValidationContext validator) {
        Boolean pseudoValue = (Boolean)this.pseudo.getValue();
        Boolean passivatingValue = (Boolean)this.passivating.getValue();
        if (pseudoValue != null && passivatingValue != null && pseudoValue.booleanValue() && passivatingValue.booleanValue()) {
            validator.addValidationError(this.passivating, "Cannot create a passivating pseudo-scope");
        }
    }

    public JavaAnnotationSource decorateSource(UIExecutionContext context, Project project, JavaAnnotationSource scope) throws Exception {
        if (((Boolean)this.pseudo.getValue()).booleanValue()) {
            scope.addAnnotation(Scope.class);
        } else {
            AnnotationSource normalScope = scope.addAnnotation(NormalScope.class);
            if (((Boolean)this.passivating.getValue()).booleanValue()) {
                normalScope.setLiteralValue("passivating", Boolean.toString(true));
            }
        }
        scope.addAnnotation(Retention.class).setEnumValue(new Enum[]{RetentionPolicy.RUNTIME});
        scope.addAnnotation(Target.class).setEnumValue(new Enum[]{ElementType.TYPE, ElementType.METHOD, ElementType.FIELD});
        scope.addAnnotation(Documented.class);
        return scope;
    }
}

