/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.ejb;

import java.io.FileNotFoundException;
import java.io.Serializable;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.jboss.forge.addon.javaee.ejb.EJBType;
import org.jboss.forge.addon.javaee.ejb.JMSDestinationType;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;

public class EJBOperations {
    public JavaResource newEJB(Project project, String ejbName, String targetPackage, EJBType ejbType, boolean serializable) throws FileNotFoundException {
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        JavaClassSource javaClass = this.createJavaClass(ejbName, targetPackage, ejbType, serializable);
        return java.saveJavaSource((JavaSource)javaClass);
    }

    public JavaResource newEJB(DirectoryResource target, String ejbName, String ejbPackage, EJBType ejbType, boolean serializable) {
        JavaClassSource javaClass = this.createJavaClass(ejbName, ejbPackage, ejbType, serializable);
        JavaResource javaResource = this.getJavaResource(target, javaClass.getName());
        javaResource.setContents((JavaSource)javaClass);
        return javaResource;
    }

    private JavaClassSource createJavaClass(String className, String classPackage, EJBType type, boolean serializable) {
        JavaClassSource ejb = (JavaClassSource)((JavaClassSource)((JavaClassSource)((JavaClassSource)Roaster.create(JavaClassSource.class)).setName(className)).setPublic()).getOrigin();
        ejb.addAnnotation(type.getAnnotation());
        if (EJBType.MESSAGEDRIVEN != type) {
            ejb.addAnnotation("javax.ejb.LocalBean");
        }
        if (serializable) {
            ejb.addInterface(Serializable.class);
            ejb.addField("private static final long serialVersionUID = -1L;");
        }
        if (classPackage != null && !classPackage.isEmpty()) {
            ejb.setPackage(classPackage);
        }
        return ejb;
    }

    public JavaClassSource setupMessageDrivenBean(JavaClassSource ejb, JMSDestinationType destType, String destName) {
        Assert.notNull((Object)((Object)destType), (String)"JMS Destination type must not be null when bean is Message Driven");
        Assert.notNull((Object)destName, (String)"JMS Destination name must not be null when bean is Message Driven");
        ejb.addImport(ActivationConfigProperty.class);
        ejb.addImport(Message.class);
        ejb.addInterface(MessageListener.class);
        ejb.addMethod("public void onMessage(Message message) {}");
        AnnotationSource annotation = ejb.getAnnotation(EJBType.MESSAGEDRIVEN.getAnnotation());
        if (annotation == null) {
            annotation = ejb.addAnnotation(EJBType.MESSAGEDRIVEN.getAnnotation());
        }
        annotation.setLiteralValue("name", "\"" + ejb.getName() + "\"").setLiteralValue("activationConfig", "{@ActivationConfigProperty(propertyName = \"destinationType\", propertyValue = \"" + destType.getDestinationType() + "\"), " + "@ActivationConfigProperty(propertyName = \"destination\", propertyValue = \"" + destName + "\")" + "}");
        return ejb;
    }

    private JavaResource getJavaResource(DirectoryResource sourceDir, String relativePath) {
        String path = relativePath.trim().endsWith(".java") ? relativePath.substring(0, relativePath.lastIndexOf(".java")) : relativePath;
        path = path.replace(".", "/") + ".java";
        JavaResource target = (JavaResource)sourceDir.getChildOfType(JavaResource.class, path);
        return target;
    }

    public boolean isEJB(JavaType<?> javaType) {
        return javaType.hasAnnotation(Stateless.class) || javaType.hasAnnotation(Stateful.class) || javaType.hasAnnotation(Singleton.class) || javaType.hasAnnotation(MessageDriven.class);
    }
}

