/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.ejb.ui;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.jboss.forge.addon.javaee.ejb.EJBOperations;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.visit.VisitContext;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;

public class EJBSetClassTransactionAttributeCommand
extends AbstractJavaEECommand {
    @Inject
    @WithAttributes(label="Target EJB", description="The EJB on which the transaction type will be set", required=true, type="org.jboss.forge.inputType.DROPDOWN")
    private UISelectOne<JavaResource> targetEjb;
    @Inject
    @WithAttributes(label="Transaction Type", description="The type of the transaction", required=true)
    private UISelectOne<TransactionAttributeType> type;
    @Inject
    private EJBOperations ejbOperations;

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("EJB: Set Class Transaction Attribute").description("Set the transaction type of a given EJB").category(Categories.create((String[])new String[]{super.getMetadata(context).getCategory().getName(), "EJB"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.setupEntities(builder.getUIContext());
        builder.add(this.targetEjb).add(this.type);
    }

    private void setupEntities(UIContext context) {
        UISelection selection = context.getInitialSelection();
        Project project = this.getSelectedProject(context);
        final ArrayList entities = new ArrayList();
        if (project != null) {
            ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).visitJavaSources(new JavaResourceVisitor(){

                public void visit(VisitContext context, JavaResource resource) {
                    try {
                        JavaType javaType = resource.getJavaType();
                        if (EJBSetClassTransactionAttributeCommand.this.ejbOperations.isEJB(javaType)) {
                            entities.add(resource);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
            });
        }
        this.targetEjb.setValueChoices(entities);
        int idx = -1;
        if (!selection.isEmpty()) {
            idx = entities.indexOf(selection.get());
        }
        if (idx == -1) {
            idx = entities.size() - 1;
        }
        if (idx != -1) {
            this.targetEjb.setDefaultValue(entities.get(idx));
        }
    }

    public Result execute(UIExecutionContext context) throws Exception {
        JavaResource resource = (JavaResource)this.targetEjb.getValue();
        JavaClassSource ejb = (JavaClassSource)resource.getJavaType();
        AnnotationSource annotation = ejb.hasAnnotation(TransactionAttribute.class) ? ejb.getAnnotation(TransactionAttribute.class) : ejb.addAnnotation(TransactionAttribute.class);
        annotation.setEnumValue(new Enum[]{(Enum)this.type.getValue()});
        resource.setContents((JavaSource)ejb);
        return Results.success((String)("Transaction attribute set to [" + this.type.getValue() + "]"));
    }

    public void validate(UIValidationContext validator) {
        super.validate(validator);
        try {
            ((JavaResource)this.targetEjb.getValue()).getJavaType();
        }
        catch (FileNotFoundException | NullPointerException e) {
            validator.addValidationError(this.targetEjb, "Type [" + this.targetEjb.getValue() + "] could not be found");
        }
    }

    protected boolean isProjectRequired() {
        return true;
    }
}

