/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.ejb.ui;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.javaee.ejb.EJBOperations;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaMethodResource;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.visit.VisitContext;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.Method;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class EJBSetMethodTransactionAttributeCommand
extends AbstractJavaEECommand {
    @Inject
    @WithAttributes(label="Target EJB", description="The EJB containing methods to be modified.", required=true, type="org.jboss.forge.inputType.DROPDOWN")
    private UISelectOne<JavaResource> targetEjb;
    @Inject
    @WithAttributes(label="Method", description="The method on which the transaction type will be set.", required=true, type="org.jboss.forge.inputType.DROPDOWN")
    private UISelectOne<JavaMethodResource> method;
    @Inject
    @WithAttributes(label="Transaction Type", description="The type of the transaction", required=true)
    private UISelectOne<TransactionAttributeType> type;
    @Inject
    private EJBOperations ejbOperations;

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("EJB: Set Method Transaction Attribute").description("Set the transaction type of a given EJB method").category(Categories.create((String[])new String[]{super.getMetadata(context).getCategory().getName(), "EJB"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.setupEJBs(builder.getUIContext());
        this.setupMethods(builder.getUIContext());
        builder.add(this.targetEjb).add(this.method).add(this.type);
    }

    private void setupMethods(UIContext uiContext) {
        this.method.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return EJBSetMethodTransactionAttributeCommand.this.targetEjb.hasValue();
            }
        });
        this.method.setValueChoices((Callable)new Callable<Iterable<JavaMethodResource>>(){

            @Override
            public Iterable<JavaMethodResource> call() throws Exception {
                ArrayList<JavaMethodResource> result = new ArrayList<JavaMethodResource>();
                if (EJBSetMethodTransactionAttributeCommand.this.targetEjb.hasValue()) {
                    JavaResource source = (JavaResource)EJBSetMethodTransactionAttributeCommand.this.targetEjb.getValue();
                    for (Resource resource : source.listResources()) {
                        if (!(resource instanceof JavaMethodResource)) continue;
                        result.add((JavaMethodResource)resource);
                    }
                }
                return result;
            }
        });
        this.method.setItemLabelConverter((Converter)new Converter<JavaMethodResource, String>(){

            public String convert(JavaMethodResource source) {
                return source.getName();
            }
        });
    }

    private void setupEJBs(UIContext context) {
        UISelection selection = context.getInitialSelection();
        Project project = this.getSelectedProject(context);
        final ArrayList entities = new ArrayList();
        if (project != null) {
            ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).visitJavaSources(new JavaResourceVisitor(){

                public void visit(VisitContext context, JavaResource resource) {
                    try {
                        JavaSource source = (JavaSource)resource.getJavaType();
                        if (EJBSetMethodTransactionAttributeCommand.this.ejbOperations.isEJB(resource.getJavaType()) && !((JavaClassSource)source).getMethods().isEmpty()) {
                            entities.add(resource);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
            });
        }
        this.targetEjb.setValueChoices(entities);
        int idx = -1;
        if (!selection.isEmpty()) {
            idx = entities.indexOf(selection.get());
        }
        if (idx == -1) {
            idx = entities.size() - 1;
        }
        if (idx != -1) {
            this.targetEjb.setDefaultValue(entities.get(idx));
        }
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Annotation annotation;
        JavaMethodResource resource = (JavaMethodResource)this.method.getValue();
        Method m = (Method)resource.getUnderlyingResourceObject();
        if (m.hasAnnotation(TransactionAttribute.class)) {
            annotation = m.getAnnotation(TransactionAttribute.class);
        } else if (m instanceof MethodSource) {
            annotation = ((MethodSource)m).addAnnotation(TransactionAttribute.class);
        } else {
            throw new IllegalStateException("Cannot add an annotation on a binary class");
        }
        if (annotation instanceof AnnotationSource) {
            ((AnnotationSource)annotation).setEnumValue(new Enum[]{(Enum)this.type.getValue()});
        }
        JavaType source = (JavaType)m.getOrigin();
        Resource parent = resource.getParent();
        if (parent instanceof JavaResource && source instanceof JavaSource) {
            ((JavaResource)parent).setContents((JavaSource)source);
        }
        return Results.success((String)("Transaction attribute set to [" + this.type.getValue() + "]"));
    }

    public void validate(UIValidationContext validator) {
        super.validate(validator);
        try {
            ((JavaResource)this.targetEjb.getValue()).getJavaType();
        }
        catch (FileNotFoundException | NullPointerException e) {
            validator.addValidationError(this.targetEjb, "Type [" + this.targetEjb.getValue() + "] could not be found");
        }
    }

    protected boolean isProjectRequired() {
        return true;
    }
}

