/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.ejb.ui;

import java.util.ArrayList;
import javax.inject.Inject;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.javaee.ejb.EJBFacet;
import org.jboss.forge.addon.javaee.ejb.EJBOperations;
import org.jboss.forge.addon.javaee.ejb.EJBType;
import org.jboss.forge.addon.javaee.ejb.ui.NewMDBSetupStep;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICategory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public class NewEJBCommand
extends AbstractJavaEECommand
implements UIWizard {
    @Inject
    @WithAttributes(label="Class name", description="The simple name of the generated class", required=true)
    private UIInput<String> named;
    @Inject
    @WithAttributes(label="Target package", type="org.jboss.forge.inputType.JAVA_PACKAGE_PICKER")
    private UIInput<String> targetPackage;
    @Inject
    @WithAttributes(label="Serializable", description="If this EJB should implement the Serializable interface.", defaultValue="true")
    private UIInput<Boolean> serializable;
    @Inject
    @WithAttributes(label="Type", description="Type type of EJB to be generated.")
    private UISelectOne<EJBType> type;
    @Inject
    @WithAttributes(label="Target Directory", required=true)
    private UIInput<DirectoryResource> targetLocation;
    @Inject
    private FacetFactory facetFactory;
    @Inject
    @WithAttributes(required=true, label="EJB Version", defaultValue="3.1")
    private UISelectOne<EJBFacet> ejbVersion;
    @Inject
    private EJBOperations ejbOperations;

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("EJB: New Bean").description("Create a new EJB").category(Categories.create((UICategory)super.getMetadata(context).getCategory(), (String[])new String[]{"EJB"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.type.setDefaultValue((Object)EJBType.STATELESS);
        Project project = this.getSelectedProject(builder.getUIContext());
        if (project == null) {
            UISelection currentSelection = builder.getUIContext().getInitialSelection();
            if (!currentSelection.isEmpty()) {
                FileResource resource = (FileResource)currentSelection.get();
                if (resource instanceof DirectoryResource) {
                    this.targetLocation.setDefaultValue((Object)((DirectoryResource)resource));
                } else {
                    this.targetLocation.setDefaultValue((Object)resource.getParent());
                }
            }
        } else {
            if (project.hasFacet(EJBFacet.class)) {
                ((UISelectOne)this.ejbVersion.setEnabled(false)).setValue((Object)project.getFacet(EJBFacet.class));
            }
            if (project.hasFacet(JavaSourceFacet.class)) {
                JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
                ((UIInput)this.targetLocation.setDefaultValue((Object)facet.getSourceDirectory())).setEnabled(false);
                this.targetPackage.setValue((Object)this.calculateServicePackage(project));
            }
        }
        builder.add(this.ejbVersion).add(this.targetLocation).add(this.targetPackage).add(this.named).add(this.type).add(this.serializable);
    }

    private String calculateServicePackage(Project project) {
        return ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).getBasePackage() + "." + "service";
    }

    public Result execute(UIExecutionContext context) throws Exception {
        ArrayList<Result> results = new ArrayList<Result>();
        if (this.ejbVersion.isEnabled() && this.facetFactory.install((Faceted)this.getSelectedProject(context.getUIContext()), (Facet)this.ejbVersion.getValue())) {
            results.add(Results.success((String)"EJB has been installed."));
        }
        String entityName = (String)this.named.getValue();
        String entityPackage = (String)this.targetPackage.getValue();
        EJBType ejbTypeChosen = (EJBType)((Object)this.type.getValue());
        DirectoryResource targetDir = (DirectoryResource)this.targetLocation.getValue();
        Project project = this.getSelectedProject((UIContextProvider)context);
        JavaResource javaResource = project == null ? this.ejbOperations.newEJB(targetDir, entityName, entityPackage, ejbTypeChosen, (boolean)((Boolean)this.serializable.getValue())) : this.ejbOperations.newEJB(project, entityName, entityPackage, ejbTypeChosen, (boolean)((Boolean)this.serializable.getValue()));
        context.getUIContext().getAttributeMap().put(JavaResource.class, javaResource);
        context.getUIContext().setSelection((Object)javaResource);
        results.add(Results.success((String)("EJB " + javaResource + " created.")));
        return Results.aggregate(results);
    }

    protected boolean isProjectRequired() {
        return true;
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        if (EJBType.MESSAGEDRIVEN.equals(this.type.getValue())) {
            return Results.navigateTo(NewMDBSetupStep.class);
        }
        return null;
    }
}

