/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.faces;

import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.ValidatorException;
import org.jboss.forge.addon.javaee.faces.FacesOperations;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class FacesOperationsImpl
implements FacesOperations {
    public JavaResource newBackingBean(Project project, String backingBeanName, String backingBeanPackage) throws FileNotFoundException {
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        JavaClassSource javaClass = this.createBackingBean(backingBeanName, backingBeanPackage);
        return java.saveJavaSource((JavaSource)javaClass);
    }

    public JavaResource newBackingBean(DirectoryResource target, String backingBeanName, String backingBeanPackage) {
        JavaClassSource javaClass = this.createBackingBean(backingBeanName, backingBeanPackage);
        JavaResource javaResource = this.getJavaResource(target, javaClass.getName());
        javaResource.setContents((JavaSource)javaClass);
        return javaResource;
    }

    public JavaResource newConverter(Project project, String converterName, String converterPackage) throws FileNotFoundException {
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        JavaClassSource javaClass = this.createConverter(converterName, converterPackage);
        return java.saveJavaSource((JavaSource)javaClass);
    }

    public JavaResource newConverter(DirectoryResource target, String converterName, String converterPackage) {
        JavaClassSource javaClass = this.createConverter(converterName, converterPackage);
        JavaResource javaResource = this.getJavaResource(target, javaClass.getName());
        javaResource.setContents((JavaSource)javaClass);
        return javaResource;
    }

    private JavaClassSource createConverter(String converterName, String converterPackage) {
        JavaClassSource source = (JavaClassSource)Roaster.parse(JavaClassSource.class, (InputStream)this.getClass().getResourceAsStream("Converter.jv"));
        source.setName(converterName);
        source.setPackage(converterPackage);
        return source;
    }

    private JavaClassSource createBackingBean(String beanName, String beanPackage) {
        JavaClassSource source = (JavaClassSource)Roaster.parse(JavaClassSource.class, (InputStream)this.getClass().getResourceAsStream("BackingBean.jv"));
        source.setName(beanName);
        source.setPackage(beanPackage);
        return source;
    }

    public JavaResource newValidator(Project project, String validatorName, String validatorPackage) throws FileNotFoundException {
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        JavaClassSource javaClass = this.createValidator(validatorName, validatorPackage);
        return java.saveJavaSource((JavaSource)javaClass);
    }

    public JavaResource newValidator(DirectoryResource target, String validatorName, String validatorPackage) {
        JavaClassSource javaClass = this.createValidator(validatorName, validatorPackage);
        JavaResource javaResource = this.getJavaResource(target, javaClass.getName());
        javaResource.setContents((JavaSource)javaClass);
        return javaResource;
    }

    private JavaClassSource createValidator(String converterName, String converterPackage) {
        JavaClassSource source = (JavaClassSource)Roaster.parse(JavaClassSource.class, (InputStream)this.getClass().getResourceAsStream("Validator.jv"));
        source.setName(converterName);
        source.setPackage(converterPackage);
        source.addAnnotation(FacesValidator.class).setStringValue(converterPackage + "." + converterName);
        return source;
    }

    private JavaResource getJavaResource(DirectoryResource sourceDir, String relativePath) {
        String path = relativePath.trim().endsWith(".java") ? relativePath.substring(0, relativePath.lastIndexOf(".java")) : relativePath;
        path = path.replace(".", "/") + ".java";
        JavaResource target = (JavaResource)sourceDir.getChildOfType(JavaResource.class, path);
        return target;
    }

    public MethodSource<JavaClassSource> addValidatorMethod(JavaResource target, String name) throws FileNotFoundException {
        JavaClassSource source = (JavaClassSource)target.getJavaType();
        MethodSource method = ((MethodSource)source.addMethod().setName(name)).setParameters("final FacesContext context, final UIComponent component, final Object value").setBody("throw new ValidatorException(new FacesMessage(\"Validator not yet implemented.\"));").addThrows(ValidatorException.class);
        ((JavaClassSource)method.getOrigin()).addImport(ValidatorException.class);
        ((JavaClassSource)method.getOrigin()).addImport(FacesMessage.class);
        ((JavaClassSource)method.getOrigin()).addImport(FacesContext.class);
        ((JavaClassSource)method.getOrigin()).addImport(UIComponent.class);
        target.setContents((JavaSource)source);
        return method;
    }
}

