/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.faces.ui;

import javax.inject.Inject;
import org.jboss.forge.addon.javaee.cdi.CDIFacet;
import org.jboss.forge.addon.javaee.cdi.ui.CDISetupCommand;
import org.jboss.forge.addon.javaee.faces.FacesFacet;
import org.jboss.forge.addon.javaee.faces.FacesOperations;
import org.jboss.forge.addon.javaee.faces.ui.AbstractFacesCommand;
import org.jboss.forge.addon.javaee.faces.ui.FacesSetupWizardImpl;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.command.PrerequisiteCommandsProvider;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICategory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class FacesNewBeanCommand
extends AbstractFacesCommand
implements PrerequisiteCommandsProvider {
    @Inject
    @WithAttributes(label="Bean name", required=true)
    private UIInput<String> named;
    @Inject
    @WithAttributes(label="Target package", type="org.jboss.forge.inputType.JAVA_PACKAGE_PICKER")
    private UIInput<String> targetPackage;
    @Inject
    @WithAttributes(label="Target Directory", required=true)
    private UIInput<DirectoryResource> targetLocation;
    @Inject
    private FacesOperations facesOperations;

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("Faces: New Bean").description("Create a new JSF Backing Bean").category(Categories.create((UICategory)super.getMetadata(context).getCategory(), (String[])new String[]{"JSF"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject(builder.getUIContext());
        if (project == null) {
            UISelection currentSelection = builder.getUIContext().getInitialSelection();
            if (!currentSelection.isEmpty()) {
                FileResource resource = (FileResource)currentSelection.get();
                if (resource instanceof DirectoryResource) {
                    this.targetLocation.setDefaultValue((Object)((DirectoryResource)resource));
                } else {
                    this.targetLocation.setDefaultValue((Object)resource.getParent());
                }
            }
        } else if (project.hasFacet(JavaSourceFacet.class)) {
            JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
            ((UIInput)this.targetLocation.setDefaultValue((Object)facet.getSourceDirectory())).setEnabled(false);
            this.targetPackage.setValue((Object)this.calculateBackingBeanPackage(project));
        }
        builder.add(this.targetLocation);
        builder.add(this.targetPackage).add(this.named);
    }

    private String calculateBackingBeanPackage(Project project) {
        return ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).getBasePackage() + "." + "view";
    }

    public Result execute(UIExecutionContext context) throws Exception {
        String beanName = (String)this.named.getValue();
        String beanPackage = (String)this.targetPackage.getValue();
        DirectoryResource targetDir = (DirectoryResource)this.targetLocation.getValue();
        UIContext uiContext = context.getUIContext();
        Project project = this.getSelectedProject(uiContext);
        JavaResource javaResource = project == null ? this.facesOperations.newBackingBean(targetDir, beanName, beanPackage) : this.facesOperations.newBackingBean(project, beanName, beanPackage);
        uiContext.setSelection((Object)javaResource);
        return Results.success((String)("Backing bean " + javaResource + " created"));
    }

    protected boolean isProjectRequired() {
        return true;
    }

    @Override
    public NavigationResult getPrerequisiteCommands(UIContext context) {
        NavigationResultBuilder builder = NavigationResultBuilder.create();
        Project project = this.getSelectedProject(context);
        if (project != null) {
            if (!project.hasFacet(CDIFacet.class)) {
                builder.add(CDISetupCommand.class);
            }
            if (!project.hasFacet(FacesFacet.class)) {
                builder.add(FacesSetupWizardImpl.class);
            }
        }
        return builder.build();
    }
}

