/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.faces.ui;

import java.io.FileNotFoundException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import org.jboss.forge.addon.javaee.faces.FacesOperations;
import org.jboss.forge.addon.javaee.faces.ui.AbstractFacesCommand;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICategory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class FacesNewValidatorMethodCommand
extends AbstractFacesCommand {
    @Inject
    @WithAttributes(label="Target Java class", description="The Java class in which the method will be created", required=true, type="org.jboss.forge.inputType.JAVA_CLASS_PICKER")
    private UIInput<JavaResource> targetClass;
    @Inject
    @WithAttributes(label="Validator method name", required=true)
    private UIInput<String> named;
    @Inject
    private FacesOperations operations;

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("Faces: New Validator Method").description("Create a new JSF validator method").category(Categories.create((UICategory)super.getMetadata(context).getCategory(), (String[])new String[]{"JSF"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Object selection = builder.getUIContext().getInitialSelection().get();
        if (selection instanceof JavaResource) {
            this.targetClass.setDefaultValue((Object)((JavaResource)selection));
        }
        builder.add(this.targetClass).add(this.named);
    }

    public void validate(UIValidationContext validator) {
        try {
            JavaClassSource source = (JavaClassSource)((JavaResource)((JavaResource)this.targetClass.getValue()).reify(JavaResource.class)).getJavaType();
            MethodSource method = source.getMethod((String)this.named.getValue(), new Class[]{FacesContext.class, UIComponent.class, Object.class});
            if (method != null) {
                validator.addValidationError(this.named, "A validator with that name already exists in '" + source.getQualifiedName() + "'");
            }
            super.validate(validator);
        }
        catch (FileNotFoundException e) {
            validator.addValidationError(this.targetClass, "Target Java class not found.");
        }
    }

    public Result execute(UIExecutionContext context) throws Exception {
        MethodSource method = this.operations.addValidatorMethod((JavaResource)((JavaResource)this.targetClass.getValue()).reify(JavaResource.class), (String)this.named.getValue());
        return Results.success((String)("Validator method '" + method.toSignature() + "' created"));
    }

    protected boolean isProjectRequired() {
        return true;
    }
}

