/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.faces.ui;

import javax.faces.application.ProjectStage;
import javax.inject.Inject;
import org.jboss.forge.addon.javaee.faces.FacesFacet;
import org.jboss.forge.addon.javaee.faces.ui.AbstractFacesCommand;
import org.jboss.forge.addon.javaee.servlet.ServletFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICategory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class FacesSetProjectStageCommand
extends AbstractFacesCommand {
    @Inject
    @WithAttributes(label="Project Stage", description="Sets the JSF project stage")
    private UISelectOne<ProjectStage> stage;

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.stage);
    }

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("Faces: Set Project Stage").description("Set the project stage of this JSF project").category(Categories.create((UICategory)super.getMetadata(context).getCategory(), (String[])new String[]{"JSF"}));
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Result result;
        Project project = this.getSelectedProject(context.getUIContext());
        FacesFacet facesFacet = (FacesFacet)project.getFacet(FacesFacet.class);
        if (this.stage.hasValue()) {
            ProjectStage projectStage = (ProjectStage)this.stage.getValue();
            facesFacet.setProjectStage(projectStage);
            result = Results.success((String)("Faces PROJECT_STAGE updated to: " + projectStage));
        } else {
            result = Results.success((String)("Project stage is currently: " + facesFacet.getProjectStage()));
        }
        return result;
    }

    public boolean isEnabled(UIContext context) {
        boolean enabled = super.isEnabled(context);
        if (enabled) {
            Project project = this.getSelectedProject(context);
            enabled = project.hasFacet(ServletFacet.class) && project.hasFacet(FacesFacet.class);
        }
        return enabled;
    }

    protected boolean isProjectRequired() {
        return true;
    }
}

