/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jaxws.ui.setup;

import javax.inject.Inject;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.javaee.facets.JAXWSFacet;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICategory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

@FacetConstraint(value={DependencyFacet.class})
public class JAXWSSetupWizard
extends AbstractJavaEECommand {
    @Inject
    private FacetFactory facetFactory;
    @Inject
    @WithAttributes(required=true, label="JAX-WS Version", defaultValue="2.2")
    private UISelectOne<JAXWSFacet> jaxwsVersion;

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("SOAP: Setup").description("Setup JAX-WS (SOAP) in your project").category(Categories.create((UICategory)super.getMetadata(context).getCategory(), (String[])new String[]{"JAX-WS"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.jaxwsVersion);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        if (this.facetFactory.install((Faceted)this.getSelectedProject((UIContextProvider)context), (Facet)this.jaxwsVersion.getValue())) {
            return Results.success((String)"JAX-WS has been installed.");
        }
        return Results.fail((String)"Could not install JAX-WS.");
    }

    protected boolean isProjectRequired() {
        return true;
    }
}

