/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import javax.persistence.Version;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.javaee.jpa.JPADataSource;
import org.jboss.forge.addon.javaee.jpa.JPAFacet;
import org.jboss.forge.addon.javaee.jpa.PersistenceContainer;
import org.jboss.forge.addon.javaee.jpa.PersistenceMetaModelFacet;
import org.jboss.forge.addon.javaee.jpa.PersistenceOperations;
import org.jboss.forge.addon.javaee.jpa.PersistenceProvider;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.ResourceException;
import org.jboss.forge.addon.resource.visit.VisitContext;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.util.Refactory;
import org.jboss.shrinkwrap.descriptor.api.persistence.PersistenceCommonDescriptor;
import org.jboss.shrinkwrap.descriptor.api.persistence.PersistenceUnitCommon;

public class PersistenceOperationsImpl
implements PersistenceOperations {
    @Inject
    private FacetFactory facetFactory;

    public FileResource<?> setup(String unitName, Project project, JPADataSource dataSource, boolean configureMetadata) {
        FileResource result = null;
        if (project != null) {
            JPAFacet facet = (JPAFacet)project.getFacet(JPAFacet.class);
            PersistenceContainer container = dataSource.getContainer();
            PersistenceProvider provider = dataSource.getProvider();
            PersistenceCommonDescriptor config = (PersistenceCommonDescriptor)facet.getConfig();
            PersistenceUnitCommon unit = null;
            List allPersistenceUnit = config.getAllPersistenceUnit();
            for (PersistenceUnitCommon persistenceUnit : allPersistenceUnit) {
                if (!unitName.equals(persistenceUnit.getName())) continue;
                unit = persistenceUnit;
                break;
            }
            if (unit == null) {
                unit = config.createPersistenceUnit();
            } else {
                unit.removeAllClazz().removeAllJarFile().removeAllMappingFile().removeDescription().removeExcludeUnlistedClasses().removeJtaDataSource().removeName().removeNonJtaDataSource().removeProperties().removeProvider();
            }
            unit.name(unitName).description("Forge Persistence Unit");
            if (provider.getProvider() != null) {
                unit.provider(provider.getProvider());
            }
            container.setupConnection(unit, dataSource);
            provider.configure(unit, dataSource, project);
            facet.saveConfig((Object)config);
            result = facet.getConfigFile();
            if (configureMetadata) {
                Iterable facets = this.facetFactory.createFacets((Faceted)project, PersistenceMetaModelFacet.class);
                for (PersistenceMetaModelFacet metaModelFacet : facets) {
                    metaModelFacet.setMetaModelProvider(provider.getMetaModelProvider());
                    if (!this.facetFactory.install((Faceted)project, (Facet)metaModelFacet)) continue;
                    break;
                }
            }
        }
        return result;
    }

    public JavaResource newEntity(Project project, String entityName, String entityPackage, GenerationType idStrategy, String tableName) throws FileNotFoundException {
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        JavaClassSource javaClass = this.createJavaEntityClass(entityName, entityPackage, idStrategy, tableName);
        return java.saveJavaSource((JavaSource)javaClass);
    }

    public JavaResource newEntity(DirectoryResource target, String entityName, String entityPackage, GenerationType idStrategy, String tableName) {
        JavaClassSource javaClass = this.createJavaEntityClass(entityName, entityPackage, idStrategy, tableName);
        JavaResource javaResource = this.getJavaResource(target, javaClass.getName());
        javaResource.setContents((JavaSource)javaClass);
        return javaResource;
    }

    public JavaResource newEmbeddableEntity(Project project, String entityName, String entityPackage) throws FileNotFoundException {
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        JavaClassSource javaClass = this.createJavaEmbeddableClass(entityName, entityPackage);
        return java.saveJavaSource((JavaSource)javaClass);
    }

    public JavaResource newEmbeddableEntity(DirectoryResource target, String entityName, String entityPackage) {
        JavaClassSource javaClass = this.createJavaEmbeddableClass(entityName, entityPackage);
        JavaResource javaResource = this.getJavaResource(target, javaClass.getName());
        javaResource.setContents((JavaSource)javaClass);
        return javaResource;
    }

    public JavaClassSource newEmbeddableEntity(JavaClassSource source) {
        return this.createJavaEmbeddableClass(source.getName(), source.getPackage());
    }

    public JavaResource newEntity(Project project, String entityName, String entityPackage, GenerationType idStrategy) throws FileNotFoundException {
        return this.newEntity(project, entityName, entityPackage, idStrategy, null);
    }

    public JavaResource newEntity(DirectoryResource target, String entityName, String entityPackage, GenerationType idStrategy) {
        return this.newEntity(target, entityName, entityPackage, idStrategy, null);
    }

    public JavaClassSource newEntity(JavaClassSource source, GenerationType idStrategy, String tableName) {
        return this.createJavaEntityClass(source.getName(), source.getPackage(), idStrategy, tableName);
    }

    private JavaClassSource createJavaEmbeddableClass(String entityName, String entityPackage) {
        JavaClassSource javaClass = (JavaClassSource)((JavaClassSource)((JavaClassSource)((JavaClassSource)((JavaClassSource)Roaster.create(JavaClassSource.class)).setName(entityName)).setPublic()).addAnnotation(Embeddable.class).getOrigin()).addInterface(Serializable.class);
        if (entityPackage != null && !entityPackage.isEmpty()) {
            javaClass.setPackage(entityPackage);
        }
        return javaClass;
    }

    private JavaClassSource createJavaEntityClass(String entityName, String entityPackage, GenerationType idStrategy, String tableName) {
        JavaClassSource javaClass = (JavaClassSource)((JavaClassSource)((JavaClassSource)((JavaClassSource)((JavaClassSource)Roaster.create(JavaClassSource.class)).setName(entityName)).setPublic()).addAnnotation(Entity.class).getOrigin()).addInterface(Serializable.class);
        if (tableName != null && !tableName.isEmpty()) {
            javaClass.addAnnotation(Table.class).setStringValue("name", tableName);
        }
        if (entityPackage != null && !entityPackage.isEmpty()) {
            javaClass.setPackage(entityPackage);
        }
        FieldSource id = javaClass.addField("private Long id;");
        id.addAnnotation(Id.class);
        id.addAnnotation(GeneratedValue.class).setEnumValue("strategy", (Enum)idStrategy);
        id.addAnnotation(Column.class).setStringValue("name", "id").setLiteralValue("updatable", "false").setLiteralValue("nullable", "false");
        FieldSource version = javaClass.addField("private int version;");
        version.addAnnotation(Version.class);
        version.addAnnotation(Column.class).setStringValue("name", "version");
        Refactory.createGetterAndSetter((JavaClassSource)javaClass, (FieldSource)id);
        Refactory.createGetterAndSetter((JavaClassSource)javaClass, (FieldSource)version);
        Refactory.createToStringFromFields((JavaClassSource)javaClass, (FieldSource[])new FieldSource[]{id});
        Refactory.createHashCodeAndEquals((JavaClassSource)javaClass, (FieldSource[])new FieldSource[]{id});
        return javaClass;
    }

    public PersistenceUnitCommon getExistingPersistenceUnit(Project project, String unitName) {
        if (project != null && project.hasFacet(JPAFacet.class)) {
            JPAFacet facet = (JPAFacet)project.getFacet(JPAFacet.class);
            PersistenceCommonDescriptor config = (PersistenceCommonDescriptor)facet.getConfig();
            List allPersistenceUnit = config.getAllPersistenceUnit();
            for (PersistenceUnitCommon persistenceUnit : allPersistenceUnit) {
                if (!unitName.equals(persistenceUnit.getName())) continue;
                return persistenceUnit;
            }
        }
        return null;
    }

    private JavaResource getJavaResource(DirectoryResource sourceDir, String relativePath) {
        String path = relativePath.trim().endsWith(".java") ? relativePath.substring(0, relativePath.lastIndexOf(".java")) : relativePath;
        path = path.replace(".", File.separator) + ".java";
        JavaResource target = (JavaResource)sourceDir.getChildOfType(JavaResource.class, path);
        return target;
    }

    public List<JavaResource> getProjectEntities(Project project) {
        final ArrayList<JavaResource> entities = new ArrayList<JavaResource>();
        if (project != null) {
            ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).visitJavaSources(new JavaResourceVisitor(){

                public void visit(VisitContext context, JavaResource resource) {
                    try {
                        JavaSource javaSource = (JavaSource)resource.getJavaType();
                        if (javaSource.hasAnnotation(Entity.class) || javaSource.hasAnnotation(Embeddable.class) || javaSource.hasAnnotation(MappedSuperclass.class)) {
                            entities.add(resource);
                        }
                    }
                    catch (FileNotFoundException | ResourceException throwable) {
                        // empty catch block
                    }
                }
            });
        }
        return entities;
    }
}

