/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa.ui;

import java.io.FileNotFoundException;
import javax.persistence.Entity;
import org.jboss.forge.addon.javaee.jpa.JPAFacet;
import org.jboss.forge.addon.javaee.jpa.ui.setup.JPASetupWizard;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.parser.java.ui.AbstractJavaSourceCommand;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.visit.VisitContext;
import org.jboss.forge.addon.ui.command.PrerequisiteCommandsProvider;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.metadata.UICategory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.roaster.model.source.JavaSource;

public abstract class AbstractJPACommand<T extends JavaSource<?>>
extends AbstractJavaSourceCommand<T>
implements PrerequisiteCommandsProvider {
    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).category(Categories.create((UICategory)Categories.create((String[])new String[]{"Java EE"}), (String[])new String[]{"JPA"}));
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected String calculateDefaultPackage(UIContext context) {
        final String[] value = new String[1];
        Project project = this.getSelectedProject(context);
        ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).visitJavaSources(new JavaResourceVisitor(){

            public void visit(VisitContext context, JavaResource javaResource) {
                try {
                    JavaSource javaSource = (JavaSource)javaResource.getJavaType();
                    if (javaSource.hasAnnotation(Entity.class)) {
                        value[0] = javaSource.getPackage();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        });
        if (value[0] == null) {
            value[0] = ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).getBasePackage() + "." + "model";
        }
        return value[0];
    }

    public NavigationResult getPrerequisiteCommands(UIContext context) {
        NavigationResultBuilder builder = NavigationResultBuilder.create();
        Project project = this.getSelectedProject(context);
        if (project != null && !project.hasFacet(JPAFacet.class)) {
            builder.add(JPASetupWizard.class);
        }
        return builder.build();
    }
}

