/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa.ui;

import javax.inject.Inject;
import org.jboss.forge.addon.javaee.jpa.ui.AbstractJPACommand;
import org.jboss.forge.addon.javaee.jpa.ui.LifecycleType;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.text.Inflector;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.roaster.model.Visibility;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class JPANewEntityListenerCommand
extends AbstractJPACommand<JavaClassSource> {
    @Inject
    @WithAttributes(label="Lifecycle", required=true)
    private UISelectMany<LifecycleType> lifecycles;
    @Inject
    private Inflector inflector;

    @Override
    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("JPA: New Entity Listener").description("Create a new JPA Entity Listener");
    }

    protected String getType() {
        return "JPA Entity Listener";
    }

    protected Class<JavaClassSource> getSourceType() {
        return JavaClassSource.class;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        builder.add(this.lifecycles);
    }

    public JavaClassSource decorateSource(UIExecutionContext context, Project project, JavaClassSource source) throws Exception {
        for (LifecycleType lifecyle : this.lifecycles.getValue()) {
            String methodName = this.inflector.lowerCamelCase(lifecyle.getAnnotation().getSimpleName(), new char[0]);
            ((MethodSource)((MethodSource)source.addMethod().setName(methodName)).setParameters("Object object").setReturnTypeVoid().setVisibility(Visibility.PRIVATE)).setBody("").addAnnotation(lifecyle.getAnnotation());
        }
        return source;
    }
}

