/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa.ui.setup;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.javaee.jpa.JPAFacet;
import org.jboss.forge.addon.javaee.jpa.PersistenceContainer;
import org.jboss.forge.addon.javaee.jpa.PersistenceMetaModelFacet;
import org.jboss.forge.addon.javaee.jpa.PersistenceProvider;
import org.jboss.forge.addon.javaee.jpa.containers.JBossEAP6Container;
import org.jboss.forge.addon.javaee.jpa.providers.HibernateProvider;
import org.jboss.forge.addon.javaee.jpa.ui.setup.JPASetupConnectionStep;
import org.jboss.forge.addon.javaee.jpa.ui.setup.JPASetupWizard;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.services.Imported;

public class JPASetupWizardImpl
extends AbstractJavaEECommand
implements JPASetupWizard {
    @Inject
    @WithAttributes(shortName=106, label="JPA Version", required=true, defaultValue="2.0")
    private UISelectOne<JPAFacet<?>> jpaVersion;
    @Inject
    @WithAttributes(shortName=99, label="Container", required=true)
    private UISelectOne<PersistenceContainer> container;
    @Inject
    @WithAttributes(shortName=112, label="Provider", required=true)
    private UISelectOne<PersistenceProvider> provider;
    @Inject
    @WithAttributes(shortName=109, label="Install a JPA 2 metamodel generator?")
    private UIInput<Boolean> configureMetadata;
    @Inject
    private JBossEAP6Container defaultContainer;
    @Inject
    private HibernateProvider defaultProvider;
    @Inject
    private Imported<PersistenceMetaModelFacet> metaModelFacets;
    @Inject
    private FacetFactory facetFactory;

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("JPA: Setup").description("Setup JPA in your project").category(Categories.create((String[])new String[]{super.getMetadata(context).getCategory().getName(), "JPA"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.initContainers(builder.getUIContext());
        this.initProviders();
        this.initConfigureMetadata();
        builder.add(this.jpaVersion).add(this.container).add(this.provider).add(this.configureMetadata);
    }

    private void initContainers(UIContext context) {
        final boolean isGUI = context.getProvider().isGUI();
        this.container.setItemLabelConverter((Converter)new Converter<PersistenceContainer, String>(){

            public String convert(PersistenceContainer source) {
                return source != null ? source.getName(isGUI) : null;
            }
        });
        TreeSet<PersistenceContainer> treeSet = new TreeSet<PersistenceContainer>(new Comparator<PersistenceContainer>(){

            @Override
            public int compare(PersistenceContainer o1, PersistenceContainer o2) {
                return String.valueOf(o1.getName(isGUI)).compareTo(o2.getName(isGUI));
            }
        });
        Iterable valueChoices = this.container.getValueChoices();
        for (PersistenceContainer persistenceContainer : valueChoices) {
            treeSet.add(persistenceContainer);
        }
        this.container.setValueChoices(treeSet);
        this.container.setDefaultValue((Object)this.defaultContainer);
    }

    private void initProviders() {
        this.provider.setItemLabelConverter((Converter)new Converter<PersistenceProvider, String>(){

            public String convert(PersistenceProvider source) {
                return source != null ? source.getName() : null;
            }
        });
        this.provider.setDefaultValue((Object)this.defaultProvider);
    }

    private void initConfigureMetadata() {
        this.configureMetadata.setDefaultValue((Object)Boolean.FALSE);
        if (this.metaModelFacets.isUnsatisfied()) {
            this.configureMetadata.setEnabled(false);
        }
    }

    public void validate(UIValidationContext validator) {
    }

    public Result execute(UIExecutionContext context) throws Exception {
        this.applyUIValues(context.getUIContext());
        Project project = this.getSelectedProject((UIContextProvider)context);
        JPAFacet facet = (JPAFacet)this.jpaVersion.getValue();
        if (this.facetFactory.install((Faceted)project, (Facet)facet)) {
            context.getUIContext().setSelection((Object)facet.getConfigFile());
            return Results.success();
        }
        return Results.fail((String)"Could not install JPA.");
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        this.applyUIValues(context.getUIContext());
        return Results.navigateTo(JPASetupConnectionStep.class);
    }

    private void applyUIValues(UIContext context) {
        Map attributeMap = context.getAttributeMap();
        attributeMap.put(JPAFacet.class, this.jpaVersion.getValue());
        attributeMap.put(PersistenceProvider.class, this.provider.getValue());
        attributeMap.put(PersistenceContainer.class, this.container.getValue());
        attributeMap.put("ConfigureMetadata", this.configureMetadata.getValue());
    }

    protected boolean isProjectRequired() {
        return true;
    }
}

