/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jstl.ui.setup;

import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.javaee.facets.JSTLFacet;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICategory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

@FacetConstraint(value={DependencyFacet.class})
public class JSTLSetupWizard
extends AbstractJavaEECommand {
    @Inject
    private FacetFactory facetFactory;
    @Inject
    @WithAttributes(required=true, label="JSTL Version")
    private UISelectOne<JSTLFacet> jstlVersion;

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("JSTL: Setup").description("Setup JSTL in your project").category(Categories.create((UICategory)super.getMetadata(context).getCategory(), (String[])new String[]{"JSTL"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.jstlVersion.setItemLabelConverter((Converter)new Converter<JSTLFacet, String>(){

            public String convert(JSTLFacet source) {
                return source.getSpecVersion().toString();
            }
        });
        for (JSTLFacet choice : this.jstlVersion.getValueChoices()) {
            if (this.jstlVersion.getValue() != null && choice.getSpecVersion().compareTo((Object)((JSTLFacet)this.jstlVersion.getValue()).getSpecVersion()) < 1) continue;
            this.jstlVersion.setDefaultValue((Object)choice);
        }
        builder.add(this.jstlVersion);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        if (this.facetFactory.install((Faceted)this.getSelectedProject((UIContextProvider)context), (Facet)this.jstlVersion.getValue())) {
            return Results.success((String)"JSTL has been installed.");
        }
        return Results.fail((String)"Could not install JSTL.");
    }

    protected boolean isProjectRequired() {
        return true;
    }
}

