/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.rest.generator.dto;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.templates.Template;
import org.jboss.forge.addon.templates.TemplateFactory;
import org.jboss.forge.addon.templates.freemarker.FreemarkerTemplate;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaClass;
import org.jboss.forge.roaster.model.Property;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.util.Refactory;
import org.jboss.forge.roaster.model.util.Strings;
import org.jboss.forge.roaster.model.util.Types;

public class DTOClassBuilder {
    private static final Map<String, String> primitiveToWrapperTypeMap = new HashMap<String, String>(8);
    private JavaClassSource dto;
    private final boolean topLevel;
    private String dtoClassName;
    private boolean isEmbeddedType;
    private final JavaClass<?> entity;
    private final StringBuilder copyCtorBuilder;
    private final StringBuilder assembleJPABuilder;
    private MethodSource<JavaClassSource> assembleJPA;
    private MethodSource<JavaClassSource> copyCtor;
    private final Property<?> idProperty;
    private final Template initializeJPAEntityFromId;
    private final Template initializeJPAEntityFromPrimitiveId;
    private final Template assembleCollection;
    private final Template assembleCollectionWithPrimitiveId;
    private final Template initializeNestedDTOCollection;

    public DTOClassBuilder(JavaClass<?> entity, Property<?> idProperty, boolean topLevel, TemplateFactory templateFactory, ResourceFactory resourceFactory) {
        this.entity = entity;
        this.idProperty = idProperty;
        this.topLevel = topLevel;
        this.copyCtorBuilder = new StringBuilder();
        this.assembleJPABuilder = new StringBuilder();
        this.initializeJPAEntityFromId = templateFactory.create(resourceFactory.create((Object)this.getClass().getResource("InitializeJPAEntityFromId.jv")), FreemarkerTemplate.class);
        this.initializeJPAEntityFromPrimitiveId = templateFactory.create(resourceFactory.create((Object)this.getClass().getResource("InitializeJPAEntityFromPrimitiveId.jv")), FreemarkerTemplate.class);
        this.assembleCollection = templateFactory.create(resourceFactory.create((Object)this.getClass().getResource("AssembleCollection.jv")), FreemarkerTemplate.class);
        this.assembleCollectionWithPrimitiveId = templateFactory.create(resourceFactory.create((Object)this.getClass().getResource("AssembleCollectionWithPrimitiveId.jv")), FreemarkerTemplate.class);
        this.initializeNestedDTOCollection = templateFactory.create(resourceFactory.create((Object)this.getClass().getResource("InitializeNestedDTOCollection.jv")), FreemarkerTemplate.class);
        this.initName();
        this.initClassStructure();
        this.initializeJPAEntityInAssembler();
    }

    public DTOClassBuilder setPackage(String dtoPackage) {
        this.dto.setPackage(dtoPackage);
        return this;
    }

    public DTOClassBuilder setEmbeddedType(boolean isEmbeddedType) {
        this.isEmbeddedType = isEmbeddedType;
        return this;
    }

    public DTOClassBuilder updateForCollectionProperty(Property<?> property, JavaClassSource nestedDTOClass, Type<?> parameterizedType, Property<?> nestedDTOId) {
        this.addCollectionProperty(property, nestedDTOClass);
        this.addInitializerFromCollection(property, nestedDTOClass, parameterizedType);
        this.addCollectionAssembler(property, parameterizedType, nestedDTOClass, nestedDTOId);
        return this;
    }

    public DTOClassBuilder updateForReferencedProperty(Property<?> property, JavaClassSource nestedDTOClass) {
        this.addProperty(property, nestedDTOClass);
        this.addInitializerFromDTO(property, nestedDTOClass);
        if (property.isMutable()) {
            this.addAssemblerForReference(property);
        }
        return this;
    }

    public DTOClassBuilder updateForSimpleProperty(Property<?> property, Type<?> type) {
        this.addProperty(property, property.getType());
        this.addInitializerFromProperty(property);
        if (!property.equals(this.idProperty) && property.isMutable()) {
            this.addPropertyAssembler(property);
        }
        return this;
    }

    public JavaClassSource createDTO() {
        if (this.topLevel && !this.isEmbeddedType) {
            this.dto.addAnnotation(XmlRootElement.class);
        }
        this.generateCopyConstructorBody();
        this.generateJPAAssemblerBody();
        return this.dto;
    }

    private void initName() {
        this.dtoClassName = (this.topLevel ? "" : "Nested") + this.entity.getName() + "DTO";
    }

    private void initClassStructure() {
        this.dto = (JavaClassSource)((JavaClassSource)((JavaClassSource)((JavaClassSource)Roaster.create(JavaClassSource.class)).setName(this.dtoClassName)).setPublic()).addInterface(Serializable.class);
        this.createDefaultConstructor();
        this.createCopyConstructor();
        this.createJPAAssembler();
    }

    private void initializeJPAEntityInAssembler() {
        if (!this.topLevel) {
            String output;
            this.dto.addImport(TypedQuery.class);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", this.idProperty.getName());
            map.put("entityName", this.entity.getName());
            map.put("jpqlVar", this.entity.getName().toLowerCase().substring(0, 1));
            try {
                if (this.idProperty.getType().isPrimitive()) {
                    String wrapperType = primitiveToWrapperTypeMap.get(this.idProperty.getType().getName());
                    map.put("wrapperType", wrapperType);
                    output = this.initializeJPAEntityFromPrimitiveId.process(map);
                } else {
                    output = this.initializeJPAEntityFromId.process(map);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.assembleJPABuilder.append(output);
        }
    }

    private void createJPAAssembler() {
        this.assembleJPA = ((MethodSource)((MethodSource)this.dto.addMethod().setName("fromDTO")).setReturnType(this.entity.getName()).setPublic()).setParameters(this.entity.getName() + " entity, EntityManager em");
        this.assembleJPABuilder.append("if(entity == null) { entity = new " + this.entity.getName() + "(); }");
    }

    private void generateJPAAssemblerBody() {
        if (!this.isEmbeddedType) {
            this.assembleJPABuilder.append("entity = em.merge(entity);");
        }
        this.assembleJPABuilder.append("return entity;");
        this.assembleJPA.setBody(this.assembleJPABuilder.toString());
    }

    private void createCopyConstructor() {
        this.dto.addImport(this.entity.getQualifiedName());
        this.dto.addImport(EntityManager.class);
        this.copyCtor = ((MethodSource)this.dto.addMethod().setConstructor(true).setPublic()).setParameters("final " + this.entity.getName() + " entity");
    }

    private void generateCopyConstructorBody() {
        this.copyCtor.setBody("if (entity != null) {\n" + this.copyCtorBuilder.toString() + "\n}");
    }

    private void createDefaultConstructor() {
        MethodSource ctor = this.dto.addMethod();
        ctor.setConstructor(true);
        ctor.setPublic();
        ctor.setBody("");
    }

    private void addCollectionProperty(Property<?> field, JavaClassSource nestedDTOClass) {
        String concreteCollectionType = null;
        String qualifiedConcreteCollectionType = null;
        String jpaCollectionType = field.getType().getName();
        String nestedDTOType = nestedDTOClass.getName();
        String qualifiedDTOType = nestedDTOClass.getQualifiedName();
        if (jpaCollectionType.equals("Set")) {
            concreteCollectionType = "HashSet";
            qualifiedConcreteCollectionType = "java.util.HashSet";
        } else if (jpaCollectionType.equals("List")) {
            concreteCollectionType = "ArrayList";
            qualifiedConcreteCollectionType = "java.util.ArrayList";
        } else if (jpaCollectionType.equals("Map")) {
            concreteCollectionType = "HashMap";
            qualifiedConcreteCollectionType = "java.util.HashMap";
        }
        FieldSource dtoField = this.dto.addField("private " + jpaCollectionType + "<" + nestedDTOType + "> " + field.getName() + "= new " + concreteCollectionType + "<" + nestedDTOType + ">();");
        this.dto.addImport(field.getType().getQualifiedName());
        this.dto.addImport(qualifiedConcreteCollectionType);
        if (!Types.isJavaLang((String)qualifiedDTOType)) {
            this.dto.addImport(qualifiedDTOType);
        }
        Refactory.createGetterAndSetter((JavaClassSource)this.dto, (FieldSource)dtoField);
    }

    private void addProperty(Property<?> field, Type<?> dtoFieldType) {
        String arrayType;
        String simpleName = dtoFieldType.getName();
        String qualifiedName = dtoFieldType.getQualifiedName();
        FieldSource dtoField = this.dto.addField("private " + simpleName + " " + field.getName() + ";");
        if (!(field.getType().isPrimitive() || Types.isJavaLang((String)qualifiedName) || Types.isArray((String)qualifiedName))) {
            this.dto.addImport(qualifiedName);
        }
        if (Types.isArray((String)qualifiedName) && !Types.isJavaLang((String)(arrayType = field.getType().getQualifiedName())) && !Types.isPrimitive((String)arrayType)) {
            this.dto.addImport(arrayType);
        }
        Refactory.createGetterAndSetter((JavaClassSource)this.dto, (FieldSource)dtoField);
    }

    private void addProperty(Property<?> property, JavaClassSource dtoFieldType) {
        String arrayType;
        String simpleName = dtoFieldType.getName();
        String qualifiedName = dtoFieldType.getQualifiedName();
        FieldSource dtoField = this.dto.addField("private " + simpleName + " " + property.getName() + ";");
        if (!(property.getType().isPrimitive() || Types.isJavaLang((String)qualifiedName) || Types.isArray((String)qualifiedName))) {
            this.dto.addImport(qualifiedName);
        }
        if (Types.isArray((String)qualifiedName) && !Types.isJavaLang((String)(arrayType = property.getType().getQualifiedName())) && !Types.isPrimitive((String)arrayType)) {
            this.dto.addImport(arrayType);
        }
        Refactory.createGetterAndSetter((JavaClassSource)this.dto, (FieldSource)dtoField);
    }

    private void addCollectionAssembler(Property<?> property, Type<?> parameterizedType, JavaClassSource nestedDTOClass, Property<?> nestedDtoId) {
        String output;
        String fieldName = property.getName();
        String simpleParameterizedType = parameterizedType.getName();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("reverseIdGetter", nestedDtoId.getAccessor().getName() + "()");
        map.put("fieldName", fieldName);
        map.put("fieldGetter", property.getAccessor().getName() + "()");
        map.put("nestedDTOType", nestedDTOClass.getName());
        map.put("jpaIterator", "iter" + Strings.capitalize((String)fieldName));
        map.put("simpleParameterizedType", simpleParameterizedType);
        map.put("jpaVar", Strings.uncapitalize((String)simpleParameterizedType));
        map.put("dtoIterator", "iterDto" + Strings.capitalize((String)fieldName));
        map.put("dtoVar", "dto" + Strings.capitalize((String)simpleParameterizedType));
        map.put("jpqlVar", simpleParameterizedType.toLowerCase().substring(0, 1));
        try {
            if (nestedDtoId.getType().isPrimitive()) {
                String wrapperType = primitiveToWrapperTypeMap.get(nestedDtoId.getType().getName());
                map.put("wrapperType", wrapperType);
                output = this.assembleCollectionWithPrimitiveId.process(map);
            } else {
                output = this.assembleCollection.process(map);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.assembleJPABuilder.append(output);
    }

    private void addAssemblerForReference(Property<?> property) {
        String fieldName = property.getName();
        String fieldSetter = property.getMutator().getName();
        String fieldGetter = property.getAccessor().getName();
        this.assembleJPABuilder.append("if(this." + fieldName + " != null) {");
        this.assembleJPABuilder.append("entity." + fieldSetter + "(this." + fieldName + ".fromDTO(entity." + fieldGetter + "(), em));");
        this.assembleJPABuilder.append("}");
    }

    private void addPropertyAssembler(Property<?> property) {
        String fieldName = property.getName();
        String fieldSetter = property.getMutator().getName();
        this.assembleJPABuilder.append("entity." + fieldSetter + "(this." + fieldName + ");");
    }

    private void addInitializerFromCollection(Property<?> property, JavaClassSource nestedDTOClass, Type<?> parameterizedType) {
        String output;
        this.dto.addImport(parameterizedType.getQualifiedName());
        this.dto.addImport(Iterator.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fieldName", property.getName());
        map.put("nestedDTOType", nestedDTOClass.getName());
        map.put("collectionIterator", "iter" + Strings.capitalize((String)property.getName()));
        map.put("elementType", parameterizedType.getName());
        map.put("fieldGetter", property.getAccessor().getName() + "()");
        try {
            output = this.initializeNestedDTOCollection.process(map);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.copyCtorBuilder.append(output);
    }

    private void addInitializerFromDTO(Property<?> property, JavaClassSource dtoClass) {
        String fieldName = property.getName();
        String fieldGetter = property.getAccessor().getName();
        String dtoType = dtoClass.getName();
        this.copyCtorBuilder.append("this." + fieldName + " = " + "new " + dtoType + "(entity." + fieldGetter + "());");
    }

    private void addInitializerFromProperty(Property<?> property) {
        String fieldName = property.getName();
        String fieldGetter = property.getAccessor().getName();
        this.copyCtorBuilder.append("this." + fieldName + " = " + "entity." + fieldGetter + "();");
    }

    static {
        primitiveToWrapperTypeMap.put("boolean", "Boolean");
        primitiveToWrapperTypeMap.put("byte", "Byte");
        primitiveToWrapperTypeMap.put("short", "Short");
        primitiveToWrapperTypeMap.put("int", "Integer");
        primitiveToWrapperTypeMap.put("long", "Long");
        primitiveToWrapperTypeMap.put("float", "Float");
        primitiveToWrapperTypeMap.put("double", "Double");
        primitiveToWrapperTypeMap.put("char", "Character");
    }
}

