/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.rest.generator.dto;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jboss.forge.roaster.model.JavaClass;
import org.jboss.forge.roaster.model.source.JavaClassSource;

public class DTOCollection {
    private final Map<JavaClass<?>, DTOPair> dtos = new HashMap();

    public Collection<JavaClassSource> allResources() {
        HashSet<JavaClassSource> result = new HashSet<JavaClassSource>();
        for (DTOPair pair : this.dtos.values()) {
            if (pair.rootDTO != null) {
                result.add(pair.rootDTO);
            }
            if (pair.nestedDTO == null) continue;
            result.add(pair.nestedDTO);
        }
        return result;
    }

    public void addRootDTO(JavaClass<?> entity, JavaClassSource rootDTO) {
        DTOPair dtoPair = this.dtos.containsKey(entity) ? this.dtos.get(entity) : new DTOPair();
        dtoPair.rootDTO = rootDTO;
        this.dtos.put(entity, dtoPair);
    }

    public void addNestedDTO(JavaClass<?> entity, JavaClassSource nestedDTO) {
        DTOPair dtoPair = this.dtos.containsKey(entity) ? this.dtos.get(entity) : new DTOPair();
        dtoPair.nestedDTO = nestedDTO;
        this.dtos.put(entity, dtoPair);
    }

    public boolean containsDTOFor(JavaClass<?> entity, boolean root) {
        if (this.dtos.get(entity) == null) {
            return false;
        }
        return root ? this.dtos.get(entity).rootDTO != null : this.dtos.get(entity).nestedDTO != null;
    }

    public JavaClassSource getDTOFor(JavaClass<?> entity, boolean root) {
        if (this.dtos.get(entity) == null) {
            return null;
        }
        return root ? this.dtos.get(entity).rootDTO : this.dtos.get(entity).nestedDTO;
    }

    private static class DTOPair {
        JavaClassSource rootDTO;
        JavaClassSource nestedDTO;

        private DTOPair() {
        }
    }
}

