/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.rest.generator.impl;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.jboss.forge.addon.javaee.jpa.JPAEntityUtil;
import org.jboss.forge.addon.javaee.rest.generation.RestGenerationContext;
import org.jboss.forge.addon.javaee.rest.generation.RestResourceGenerator;
import org.jboss.forge.addon.javaee.rest.generator.ResourceGeneratorUtil;
import org.jboss.forge.addon.javaee.rest.generator.dto.DTOClassBuilder;
import org.jboss.forge.addon.javaee.rest.generator.dto.DTOCollection;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceException;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.templates.Template;
import org.jboss.forge.addon.templates.TemplateFactory;
import org.jboss.forge.addon.templates.freemarker.FreemarkerTemplate;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.Field;
import org.jboss.forge.roaster.model.JavaClass;
import org.jboss.forge.roaster.model.Method;
import org.jboss.forge.roaster.model.Property;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.util.Types;

public class RootAndNestedDTOResourceGenerator
implements RestResourceGenerator {
    @Inject
    TemplateFactory templateFactory;
    @Inject
    ResourceFactory resourceFactory;

    public List<JavaClassSource> generateFrom(RestGenerationContext context) throws Exception {
        ArrayList<JavaClassSource> result = new ArrayList<JavaClassSource>();
        JavaClassSource entity = context.getEntity();
        Project project = context.getProject();
        String contentType = ResourceGeneratorUtil.getContentType(context.getContentType());
        String idType = JPAEntityUtil.resolveIdType(entity);
        String persistenceUnitName = context.getPersistenceUnitName();
        String idGetterName = JPAEntityUtil.resolveIdGetterName(entity);
        String entityTable = JPAEntityUtil.getEntityTable(entity);
        String selectExpression = JPAEntityUtil.getSelectExpression(entity, entityTable);
        String idClause = JPAEntityUtil.getIdClause(entity, entityTable);
        String orderClause = JPAEntityUtil.getOrderClause(entity, JPAEntityUtil.getJpqlEntityVariable(entityTable));
        String resourcePath = ResourceGeneratorUtil.getResourcePath(context);
        DTOCollection createdDtos = this.from(project, (JavaClass<?>)entity, context.getTargetPackageName() + ".dto");
        JavaClassSource rootDto = createdDtos.getDTOFor((JavaClass<?>)entity, true);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entity", entity);
        map.put("dto", rootDto);
        map.put("idType", idType);
        map.put("getIdStatement", idGetterName);
        map.put("contentType", contentType);
        map.put("persistenceUnitName", persistenceUnitName);
        map.put("entityTable", entityTable);
        map.put("selectExpression", selectExpression);
        map.put("idClause", idClause);
        map.put("orderClause", orderClause);
        map.put("resourcePath", resourcePath);
        map.put("idIsPrimitive", Types.isPrimitive((String)idType));
        Resource templateResource = this.resourceFactory.create((Object)this.getClass().getResource("EndpointWithDTO.jv"));
        Template processor = this.templateFactory.create(templateResource, FreemarkerTemplate.class);
        String output = processor.process(map);
        JavaClassSource resource = (JavaClassSource)Roaster.parse(JavaClassSource.class, (String)output);
        resource.addImport(rootDto.getQualifiedName());
        resource.addImport(entity.getQualifiedName());
        resource.setPackage(context.getTargetPackageName());
        result.add(resource);
        result.addAll(createdDtos.allResources());
        return result;
    }

    public DTOCollection from(Project project, JavaClass<?> entity, String dtoPackage) {
        DTOCollection dtoCollection = new DTOCollection();
        if (entity == null) {
            throw new IllegalArgumentException("The argument entity was null.");
        }
        this.generatedDTOGraphForEntity(project, entity, dtoPackage, true, false, dtoCollection);
        return dtoCollection;
    }

    private JavaClassSource generatedDTOGraphForEntity(Project project, JavaClass<?> entity, String dtoPackage, boolean topLevel, boolean isEmbeddedType, DTOCollection dtoCollection) {
        if (dtoCollection.containsDTOFor(entity, topLevel)) {
            return dtoCollection.getDTOFor(entity, topLevel);
        }
        Property<?> idProperty = this.parseIdPropertyForJPAEntity(entity);
        DTOClassBuilder dtoClassBuilder = new DTOClassBuilder(entity, idProperty, topLevel, this.templateFactory, this.resourceFactory).setPackage(dtoPackage).setEmbeddedType(isEmbeddedType);
        for (Property property : entity.getProperties()) {
            boolean isEmbedded;
            Field field = property.getField();
            Method accessor = property.getAccessor();
            if (field != null ? field.isTransient() || field.hasAnnotation(Transient.class) : accessor.hasAnnotation(Transient.class)) continue;
            String qualifiedPropertyType = property.getType().getQualifiedName();
            JavaClass<?> propertyClass = this.tryGetJavaClass(project, qualifiedPropertyType);
            boolean isReadable = property.isAccessible();
            boolean isCollection = property.hasAnnotation(OneToMany.class) || property.hasAnnotation(ManyToMany.class);
            Type propertyTypeInspector = property.getType();
            boolean parameterized = propertyTypeInspector.isParameterized();
            boolean hasAssociation = property.hasAnnotation(OneToOne.class) || property.hasAnnotation(ManyToOne.class);
            boolean bl = isEmbedded = property.hasAnnotation(Embedded.class) || propertyClass != null && propertyClass.hasAnnotation(Embeddable.class);
            if (!isReadable) continue;
            if (isCollection && parameterized) {
                Type type;
                String qualifiedParameterizedType;
                JavaClass<?> parameterizedClass;
                if (!topLevel || (parameterizedClass = this.tryGetJavaClass(project, qualifiedParameterizedType = (type = (Type)propertyTypeInspector.getTypeArguments().get(0)).getQualifiedName())) == null) continue;
                JavaClassSource nestedDTOClass = this.generatedDTOGraphForEntity(project, parameterizedClass, dtoPackage, false, false, dtoCollection);
                Property<?> nestedDtoId = this.parseIdPropertyForJPAEntity(parameterizedClass);
                dtoClassBuilder.updateForCollectionProperty(property, nestedDTOClass, type, nestedDtoId);
                continue;
            }
            if (hasAssociation) {
                JavaClass<?> associatedClass;
                if (!topLevel || (associatedClass = this.tryGetJavaClass(project, qualifiedPropertyType)) == null) continue;
                JavaClassSource nestedDTOClass = this.generatedDTOGraphForEntity(project, associatedClass, dtoPackage, false, false, dtoCollection);
                dtoClassBuilder.updateForReferencedProperty(property, nestedDTOClass);
                continue;
            }
            if (isEmbedded) {
                JavaClassSource dtoForEmbeddedType = this.generatedDTOGraphForEntity(project, propertyClass, dtoPackage, true, true, dtoCollection);
                dtoClassBuilder.updateForReferencedProperty(property, dtoForEmbeddedType);
                continue;
            }
            dtoClassBuilder.updateForSimpleProperty(property, property.getType());
        }
        JavaClassSource dtoClass = dtoClassBuilder.createDTO();
        if (topLevel) {
            dtoCollection.addRootDTO(entity, dtoClass);
        } else {
            dtoCollection.addNestedDTO(entity, dtoClass);
        }
        return dtoClass;
    }

    private Property<?> parseIdPropertyForJPAEntity(JavaClass<?> bean) {
        for (Property property : bean.getProperties()) {
            Field field = property.getField();
            if (field != null && (field.hasAnnotation(Id.class) || field.hasAnnotation(EmbeddedId.class))) {
                return property;
            }
            Method accessor = property.getAccessor();
            if (accessor == null || !accessor.hasAnnotation(Id.class) && !accessor.hasAnnotation(EmbeddedId.class)) continue;
            return property;
        }
        return null;
    }

    private JavaClass<?> tryGetJavaClass(Project project, String qualifiedFieldType) {
        try {
            JavaResource javaResource = ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).getJavaResource(qualifiedFieldType);
            JavaClass javaClass = (JavaClass)javaResource.getJavaType();
            return javaClass;
        }
        catch (ClassCastException classCastException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
        return null;
    }

    public String getName() {
        return "ROOT_AND_NESTED_DTO";
    }

    public String getDescription() {
        return "Expose DTOs for JPA entities in the REST resources";
    }
}

