/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.servlet;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.addon.javaee.AbstractJavaEEFacet;
import org.jboss.forge.addon.javaee.servlet.ServletFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFilter;
import org.jboss.shrinkwrap.descriptor.api.webapp.WebAppCommonDescriptor;

public abstract class AbstractServletFacet<DESCRIPTOR extends WebAppCommonDescriptor>
extends AbstractJavaEEFacet
implements ServletFacet<DESCRIPTOR> {
    @Inject
    public AbstractServletFacet(DependencyInstaller installer) {
        super(installer);
    }

    public String getSpecName() {
        return "Servlet";
    }

    @Override
    public boolean isInstalled() {
        Project project = (Project)this.getFaceted();
        DirectoryResource webRoot = ((WebResourcesFacet)project.getFacet(WebResourcesFacet.class)).getWebRootDirectory();
        return super.isInstalled() && webRoot.exists();
    }

    @Override
    public boolean install() {
        Project project;
        DirectoryResource webRoot;
        if (!this.isInstalled() && !(webRoot = ((WebResourcesFacet)(project = (Project)this.getFaceted()).getFacet(WebResourcesFacet.class)).getWebRootDirectory()).exists()) {
            webRoot.mkdirs();
        }
        return super.install();
    }

    public FileResource<?> getConfigFile() {
        Project project = (Project)this.getFaceted();
        DirectoryResource webRoot = ((WebResourcesFacet)project.getFacet(WebResourcesFacet.class)).getWebRootDirectory();
        return (FileResource)webRoot.getChild("WEB-INF" + File.separator + "web.xml");
    }

    public List<Resource<?>> getResources() {
        DirectoryResource webRoot = ((WebResourcesFacet)((Project)this.getFaceted()).getFacet(WebResourcesFacet.class)).getWebRootDirectory();
        return this.listChildrenRecursively(webRoot);
    }

    private List<Resource<?>> listChildrenRecursively(DirectoryResource webRoot) {
        return this.listChildrenRecursively(webRoot, new ResourceFilter(){

            public boolean accept(Resource<?> resource) {
                return true;
            }
        });
    }

    public List<Resource<?>> getResources(ResourceFilter filter) {
        DirectoryResource webRoot = ((WebResourcesFacet)((Project)this.getFaceted()).getFacet(WebResourcesFacet.class)).getWebRootDirectory();
        return this.listChildrenRecursively(webRoot, filter);
    }

    public DirectoryResource getWebInfDirectory() {
        return ((WebResourcesFacet)((Project)this.getFaceted()).getFacet(WebResourcesFacet.class)).getWebRootDirectory().getChildDirectory("WEB-INF");
    }

    private List<Resource<?>> listChildrenRecursively(DirectoryResource current, ResourceFilter filter) {
        ArrayList result = new ArrayList();
        List list = current.listResources();
        if (list != null) {
            for (Resource file : list) {
                if (file instanceof DirectoryResource) {
                    result.addAll(this.listChildrenRecursively((DirectoryResource)file, filter));
                }
                if (!filter.accept((Object)file)) continue;
                result.add(file);
            }
        }
        return result;
    }
}

