/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.ui;

import javax.inject.Inject;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.javaee.facets.JavaEESpecFacet;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;

public class JavaEESetupCommand
extends AbstractJavaEECommand {
    @Inject
    private FacetFactory facetFactory;
    @Inject
    private ProjectFactory projectFactory;
    @Inject
    @WithAttributes(required=true, label="Java EE Version", defaultValue="6")
    private UISelectOne<JavaEESpecFacet> javaEEVersion;

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("JavaEE: Setup").description("Setup Java EE in your project");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.javaEEVersion);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        JavaEESpecFacet chosen = (JavaEESpecFacet)this.javaEEVersion.getValue();
        if (this.facetFactory.install((Faceted)this.getSelectedProject(context.getUIContext()), (Facet)chosen)) {
            this.projectFactory.invalidateCaches();
            return Results.success((String)("JavaEE " + chosen.getSpecVersion() + " has been installed."));
        }
        return Results.fail((String)("Could not install JavaEE " + chosen.getSpecVersion()));
    }

    protected boolean isProjectRequired() {
        return true;
    }
}

