/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.validation;

import java.util.Set;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.javaee.validation.ValidationFacet;
import org.jboss.forge.addon.javaee.validation.provider.ValidationProvider;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.shrinkwrap.descriptor.api.validationConfiguration11.ValidationConfigurationDescriptor;

public class ValidationOperations {
    @Inject
    private DependencyInstaller installer;
    @Inject
    private FacetFactory facetFactory;

    public void setup(Project project, ValidationProvider provider, boolean provided, String messageInterpolator, String traversableResolver, String constraintValidatorFactory) throws Exception {
        if (project != null) {
            ValidationFacet facet = (ValidationFacet)this.facetFactory.install((Faceted)project, ValidationFacet.class);
            String scopeType = provided ? "PROVIDED" : "COMPILE";
            this.installDependencies(project, provider.getDependencies(), scopeType);
            this.installDependencies(project, provider.getAdditionalDependencies(), scopeType);
            ValidationConfigurationDescriptor descriptor = (ValidationConfigurationDescriptor)facet.getConfig();
            if (provider.getDefaultDescriptor() != null) {
                ValidationConfigurationDescriptor providerDescriptor = provider.getDefaultDescriptor();
                String defaultProvider = providerDescriptor.getDefaultProvider();
                if (Strings.isNullOrEmpty((String)defaultProvider)) {
                    descriptor.removeDefaultProvider();
                } else {
                    descriptor.defaultProvider(defaultProvider);
                }
                if (Strings.isNullOrEmpty((String)messageInterpolator)) {
                    descriptor.removeMessageInterpolator();
                } else {
                    descriptor.messageInterpolator(messageInterpolator);
                }
                if (Strings.isNullOrEmpty((String)traversableResolver)) {
                    descriptor.removeTraversableResolver();
                } else {
                    descriptor.traversableResolver(traversableResolver);
                }
                if (Strings.isNullOrEmpty((String)constraintValidatorFactory)) {
                    descriptor.removeConstraintValidatorFactory();
                } else {
                    descriptor.constraintValidatorFactory(constraintValidatorFactory);
                }
            }
            facet.saveConfig((Object)descriptor);
        }
    }

    private void installDependencies(Project project, Set<Dependency> dependencies, String scopeType) {
        for (Dependency dep : dependencies) {
            if (this.installer.isInstalled(project, dep)) continue;
            dep = DependencyBuilder.create((Dependency)dep).setScopeType(scopeType);
            this.installer.install(project, dep);
        }
    }
}

