/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.validation.ui;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.Payload;
import javax.validation.ReportAsSingleViolation;
import org.jboss.forge.addon.javaee.validation.ui.AbstractValidationCommand;
import org.jboss.forge.addon.javaee.validation.ui.ValidationNewAnnotationCommand;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.roaster.model.source.JavaAnnotationSource;

public class ValidationNewAnnotationCommandImpl
extends AbstractValidationCommand<JavaAnnotationSource>
implements ValidationNewAnnotationCommand {
    @Override
    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("Constraint: New Annotation").description("Create a Bean Validation constraint annotation");
    }

    protected String getType() {
        return "Constraint Annotation";
    }

    protected Class<JavaAnnotationSource> getSourceType() {
        return JavaAnnotationSource.class;
    }

    public JavaAnnotationSource decorateSource(UIExecutionContext context, Project project, JavaAnnotationSource constraint) throws Exception {
        constraint.addAnnotation(Constraint.class).setLiteralValue("validatedBy", "{}");
        constraint.addAnnotation(ReportAsSingleViolation.class);
        constraint.addAnnotation(Retention.class).setEnumValue(new Enum[]{RetentionPolicy.RUNTIME});
        constraint.addAnnotation(Target.class).setEnumValue(new Enum[]{ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.TYPE, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR});
        constraint.addAnnotation(Documented.class);
        constraint.addImport(Payload.class);
        constraint.addAnnotationElement("String message() default \"Invalid value\"");
        constraint.addAnnotationElement("Class<?>[] groups() default { }");
        constraint.addAnnotationElement("Class<? extends Payload>[] payload() default { }");
        JavaAnnotationSource listNestedAnnotation = (JavaAnnotationSource)constraint.addNestedType(JavaAnnotationSource.class);
        listNestedAnnotation.setName("List");
        listNestedAnnotation.addAnnotation(Retention.class).setEnumValue(new Enum[]{RetentionPolicy.RUNTIME});
        listNestedAnnotation.addAnnotation(Target.class).setEnumValue(new Enum[]{ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.TYPE, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR});
        listNestedAnnotation.addAnnotationElement(constraint.getName() + "[] value()");
        return constraint;
    }
}

