/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.validation.ui;

import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.javaee.validation.ConstraintOperations;
import org.jboss.forge.addon.javaee.validation.ConstraintType;
import org.jboss.forge.addon.javaee.validation.CoreConstraints;
import org.jboss.forge.addon.javaee.validation.ui.ValidationGenerateConstraintWizardStep;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.forge.roaster.model.JavaClass;
import org.jboss.forge.roaster.model.Property;
import org.jboss.forge.roaster.model.source.PropertySource;

public class ValidationSelectFieldWizardStep
extends AbstractJavaEECommand
implements UIWizardStep {
    @Inject
    @WithAttributes(label="On Property", description="The property on which the constraint applies", required=true, type="org.jboss.forge.inputType.DROPDOWN")
    private UISelectOne<PropertySource<?>> onProperty;
    @Inject
    @WithAttributes(label="Constraint", description="The type of constraint to add", required=true, type="org.jboss.forge.inputType.DROPDOWN")
    private UISelectOne<CoreConstraints> constraint;
    @Inject
    @WithAttributes(label="Add constraint on the property accessor?")
    private UIInput<Boolean> onAccessor;
    @Inject
    private ConstraintOperations constraintOperations;

    public void initializeUI(UIBuilder builder) throws Exception {
        this.setupProperty(builder.getUIContext());
        this.setupConstraint();
        this.setupAccessor();
        builder.add(this.onProperty).add(this.constraint).add(this.onAccessor);
    }

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ValidationSelectFieldWizardStep.class).name("Select constrained field").description("Select the property you wish to constraint");
    }

    private void setupProperty(final UIContext context) throws Exception {
        this.onProperty.setItemLabelConverter(new Converter<PropertySource<?>, String>(){

            public String convert(PropertySource<?> source) {
                return source == null ? null : source.getName();
            }
        });
        this.onProperty.setValueChoices(new Callable<Iterable<PropertySource<?>>>(){

            @Override
            public Iterable<PropertySource<?>> call() throws Exception {
                JavaResource selectedResource = (JavaResource)context.getAttributeMap().get(JavaResource.class);
                JavaClass javaClass = (JavaClass)selectedResource.getJavaType();
                return javaClass.getProperties();
            }
        });
    }

    private void setupConstraint() {
        this.constraint.setItemLabelConverter((Converter)new Converter<CoreConstraints, String>(){

            public String convert(CoreConstraints source) {
                return source == null ? null : source.getDescription();
            }
        });
        this.constraint.setValueChoices(EnumSet.allOf(CoreConstraints.class));
    }

    private void setupAccessor() {
        this.onAccessor.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Property value = (Property)ValidationSelectFieldWizardStep.this.onProperty.getValue();
                return value == null ? Boolean.FALSE.booleanValue() : value.isAccessible();
            }
        });
    }

    public Result execute(UIExecutionContext context) throws Exception {
        ConstraintType constraintType = (ConstraintType)this.constraint.getValue();
        if (constraintType == CoreConstraints.VALID) {
            Project project = this.getSelectedProject((UIContextProvider)context);
            Result result = this.constraintOperations.addValidConstraint(project, (PropertySource)this.onProperty.getValue(), (Boolean)this.onAccessor.getValue());
            return result;
        }
        return Results.success();
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        ConstraintType constraintType = (ConstraintType)this.constraint.getValue();
        UIContext uiContext = context.getUIContext();
        Map attributeMap = uiContext.getAttributeMap();
        attributeMap.put(PropertySource.class, this.onProperty.getValue());
        attributeMap.put(ConstraintType.class, constraintType);
        attributeMap.put("onAccessor", this.onAccessor.getValue());
        if (constraintType == CoreConstraints.VALID) {
            return null;
        }
        return Results.navigateTo(ValidationGenerateConstraintWizardStep.class);
    }

    protected boolean isProjectRequired() {
        return false;
    }
}

