/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.cdi;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.decorator.Decorator;
import javax.ejb.MessageDriven;
import javax.faces.convert.FacesConverter;
import javax.faces.validator.FacesValidator;
import javax.inject.Qualifier;
import javax.interceptor.Interceptor;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import javax.validation.ConstraintValidator;
import javax.validation.Payload;
import javax.ws.rs.Path;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.ResourceException;
import org.jboss.forge.addon.resource.visit.VisitContext;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.JavaSource;

public class CDIOperations {
    public static final List<String> DEFAULT_QUALIFIERS = Arrays.asList("javax.enterprise.inject.Default", "javax.enterprise.inject.Any");

    public List<JavaResource> getProjectInjectableBeans(Project project) {
        final ArrayList<JavaResource> beans = new ArrayList<JavaResource>();
        if (project != null) {
            ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).visitJavaSources(new JavaResourceVisitor(){

                public void visit(VisitContext context, JavaResource resource) {
                    try {
                        JavaSource javaSource = (JavaSource)resource.getJavaType();
                        if (!(javaSource.isAnnotation() || javaSource.isEnum() || javaSource.hasAnnotation(Decorator.class) || javaSource.hasAnnotation(Interceptor.class) || javaSource.hasAnnotation(MessageDriven.class) || javaSource.hasAnnotation(Entity.class) || javaSource.hasAnnotation(Embeddable.class) || javaSource.hasAnnotation(MappedSuperclass.class) || javaSource.hasAnnotation(FacesConverter.class) || javaSource.hasAnnotation(FacesValidator.class) || javaSource.hasAnnotation(Path.class) || javaSource.hasAnnotation(WebServlet.class) || javaSource.hasAnnotation(WebFilter.class) || javaSource.hasAnnotation(WebListener.class) || javaSource.hasImport(ConstraintValidator.class) || javaSource.hasImport(Payload.class))) {
                            beans.add(resource);
                        }
                    }
                    catch (FileNotFoundException | ResourceException throwable) {
                        // empty catch block
                    }
                }
            });
        }
        return beans;
    }

    public List<JavaResource> getProjectInjectionPointBeans(Project project) {
        final ArrayList<JavaResource> beans = new ArrayList<JavaResource>();
        if (project != null) {
            ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).visitJavaSources(new JavaResourceVisitor(){

                public void visit(VisitContext context, JavaResource resource) {
                    try {
                        JavaSource javaSource = (JavaSource)resource.getJavaType();
                        if (!(!javaSource.isClass() || javaSource.hasAnnotation(Entity.class) || javaSource.hasAnnotation(MappedSuperclass.class) || javaSource.hasAnnotation(Embeddable.class) || javaSource.hasImport(Payload.class))) {
                            beans.add(resource);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
            });
        }
        return beans;
    }

    public List<JavaResource> getProjectQualifiers(Project project) {
        final ArrayList<JavaResource> qualifiers = new ArrayList<JavaResource>();
        if (project != null) {
            ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).visitJavaSources(new JavaResourceVisitor(){

                public void visit(VisitContext context, JavaResource resource) {
                    try {
                        JavaType javaType = resource.getJavaType();
                        if (javaType.isAnnotation() && javaType.hasAnnotation(Qualifier.class)) {
                            qualifiers.add(resource);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
            });
        }
        return qualifiers;
    }

    public List<JavaResource> getProjectEventTypes(Project project) {
        final ArrayList<JavaResource> eventTypes = new ArrayList<JavaResource>();
        if (project != null) {
            ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).visitJavaSources(new JavaResourceVisitor(){

                public void visit(VisitContext context, JavaResource resource) {
                    eventTypes.add(resource);
                }
            });
        }
        return eventTypes;
    }
}

