/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.cdi.ui;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.addon.javaee.cdi.CDIFacet;
import org.jboss.forge.addon.javaee.cdi.CDIOperations;
import org.jboss.forge.addon.javaee.cdi.ui.CDISetupCommand;
import org.jboss.forge.addon.javaee.cdi.ui.input.Qualifiers;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.parser.java.beans.FieldOperations;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.command.PrerequisiteCommandsProvider;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIPrompt;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICategory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.roaster.model.Field;
import org.jboss.forge.roaster.model.Visibility;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;

public class CDIAddInjectionPointCommand
extends AbstractJavaEECommand
implements PrerequisiteCommandsProvider {
    @Inject
    @WithAttributes(label="Field Name", description="The field name to be injected in the target bean", required=true)
    private UIInput<String> named;
    @Inject
    @WithAttributes(label="Target Class", description="The class where the injection point will be added", required=true, type="org.jboss.forge.inputType.DROPDOWN")
    private UISelectOne<JavaResource> targetClass;
    @Inject
    @WithAttributes(label="Field Type", description="The type intended to be used for this field", type="org.jboss.forge.inputType.JAVA_CLASS_PICKER", required=true)
    private UIInput<String> type;
    @Inject
    private Qualifiers qualifiers;
    @Inject
    private FieldOperations beanOperations;
    @Inject
    private CDIOperations cdiOperations;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("CDI: Add Injection Point").description("Adds a new injection point field to a bean").category(Categories.create((UICategory)Categories.create((String[])new String[]{"Java EE"}), (String[])new String[]{"CDI"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.setupTargetClasses(builder.getUIContext());
        this.setupType();
        builder.add(this.targetClass).add(this.named).add(this.type).add((InputComponent)this.qualifiers);
    }

    private void setupTargetClasses(UIContext uiContext) {
        UISelection selection = uiContext.getInitialSelection();
        Project project = this.getSelectedProject(uiContext);
        List<JavaResource> classes = this.cdiOperations.getProjectInjectionPointBeans(project);
        this.targetClass.setValueChoices(classes);
        int idx = -1;
        if (!selection.isEmpty()) {
            idx = classes.indexOf(selection.get());
        }
        if (idx == -1) {
            idx = classes.size() - 1;
        }
        if (idx != -1) {
            this.targetClass.setDefaultValue((Object)classes.get(idx));
        }
    }

    private void setupType() {
        this.type.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                Project project = CDIAddInjectionPointCommand.this.getSelectedProject(context);
                ArrayList<String> options = new ArrayList<String>();
                if (project != null) {
                    for (JavaResource resource : CDIAddInjectionPointCommand.this.cdiOperations.getProjectInjectableBeans(project)) {
                        try {
                            JavaSource javaSource = (JavaSource)resource.getJavaType();
                            String qualifiedName = javaSource.getQualifiedName();
                            if (!Strings.isNullOrEmpty((String)value) && !qualifiedName.startsWith(value)) continue;
                            options.add(qualifiedName);
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                    }
                }
                return options;
            }
        });
    }

    public Result execute(UIExecutionContext context) throws Exception {
        JavaResource javaResource = (JavaResource)this.targetClass.getValue();
        String fieldNameStr = (String)this.named.getValue();
        JavaClassSource targetBean = (JavaClassSource)javaResource.getJavaType();
        FieldSource field = targetBean.getField(fieldNameStr);
        if (field != null) {
            UIPrompt prompt = context.getPrompt();
            if (prompt.promptBoolean("Field '" + field.getName() + "' already exists. Do you want to overwrite it?")) {
                this.beanOperations.removeField(targetBean, (Field)field);
            } else {
                return Results.fail((String)("Field '" + field.getName() + "' already exists."));
            }
        }
        FieldSource injectionPoint = ((FieldSource)((FieldSource)targetBean.addField().setName(fieldNameStr)).setVisibility(Visibility.PRIVATE)).setType((String)this.type.getValue());
        injectionPoint.addAnnotation(Inject.class);
        for (String qualifier : this.qualifiers.getValue()) {
            injectionPoint.addAnnotation(qualifier);
        }
        javaResource.setContents((JavaSource)targetBean);
        return Results.success((String)("Injection point " + fieldNameStr + " was added."));
    }

    public void validate(UIValidationContext validator) {
        super.validate(validator);
        try {
            JavaClassSource javaClass;
            JavaResource javaResource = (JavaResource)this.targetClass.getValue();
            if (javaResource != null && (javaClass = (JavaClassSource)javaResource.getJavaType()).hasField((String)this.named.getValue())) {
                validator.addValidationWarning(this.targetClass, "Field '" + (String)this.named.getValue() + "' already exists");
            }
        }
        catch (FileNotFoundException ffe) {
            validator.addValidationError(this.targetClass, "Bean could not be found");
        }
    }

    protected boolean isProjectRequired() {
        return true;
    }

    public NavigationResult getPrerequisiteCommands(UIContext context) {
        NavigationResultBuilder builder = NavigationResultBuilder.create();
        Project project = this.getSelectedProject(context);
        if (project != null && !project.hasFacet(CDIFacet.class)) {
            builder.add(CDISetupCommand.class);
        }
        return builder.build();
    }
}

