/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.cdi.ui;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import org.jboss.forge.addon.javaee.cdi.CDIOperations;
import org.jboss.forge.addon.javaee.cdi.ui.AbstractCDICommand;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.ClassLoaderFacet;
import org.jboss.forge.addon.resource.ResourceException;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.roaster.model.source.AnnotationElementSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaAnnotationSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.util.Types;

public class CDINewAnnotationLiteralCommand
extends AbstractCDICommand<JavaClassSource> {
    @Inject
    @WithAttributes(label="Qualifier", type="org.jboss.forge.inputType.JAVA_CLASS_PICKER", required=true)
    private UIInput<String> qualifier;
    @Inject
    private CDIOperations cdiOperations;

    @Override
    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("CDI: New Annotation Literal").description("Creates an Annotation Literal Type");
    }

    protected String getType() {
        return "CDI Annotation Literal Type";
    }

    protected Class<JavaClassSource> getSourceType() {
        return JavaClassSource.class;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        this.setupQualifiers();
        builder.add(this.qualifier);
    }

    private void setupQualifiers() {
        this.qualifier.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                Project project = CDINewAnnotationLiteralCommand.this.getSelectedProject(context);
                ArrayList<String> options = new ArrayList<String>();
                for (String type : CDIOperations.DEFAULT_QUALIFIERS) {
                    if (!Strings.isNullOrEmpty((String)value) && !type.startsWith(value)) continue;
                    options.add(type);
                }
                if (project != null) {
                    for (JavaResource resource : CDINewAnnotationLiteralCommand.this.cdiOperations.getProjectQualifiers(project)) {
                        try {
                            JavaSource javaSource = (JavaSource)resource.getJavaType();
                            String qualifiedName = javaSource.getQualifiedName();
                            if (!Strings.isNullOrEmpty((String)value) && !qualifiedName.startsWith(value)) continue;
                            options.add(qualifiedName);
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                    }
                }
                return options;
            }
        });
    }

    public JavaClassSource decorateSource(UIExecutionContext context, Project project, JavaClassSource annotationLiteral) throws Exception {
        String qualifierClassName = (String)this.qualifier.getValue();
        Map<String, String> nameTypeMap = this.extractQualifierMethods(project);
        annotationLiteral.addImport(qualifierClassName);
        annotationLiteral.addImport(AnnotationLiteral.class);
        ((JavaClassSource)annotationLiteral.setSuperType("AnnotationLiteral<" + Types.toSimpleName((String)qualifierClassName) + ">")).addInterface(qualifierClassName);
        StringBuilder constructorBody = new StringBuilder();
        MethodSource constructor = (MethodSource)annotationLiteral.addMethod().setConstructor(true).setPublic();
        for (Map.Entry<String, String> entry : nameTypeMap.entrySet()) {
            String name = entry.getKey();
            String type = entry.getValue();
            ((FieldSource)((FieldSource)((FieldSource)annotationLiteral.addField().setPrivate()).setFinal(true)).setName(name)).setType(type);
            ((MethodSource)((MethodSource)annotationLiteral.addMethod().setPublic()).setName(name)).setReturnType(type).setBody("return this." + name + ";");
            constructor.addParameter(type, name);
            constructorBody.append("this.").append(name).append("=").append(name).append(";").append(System.lineSeparator());
        }
        constructor.setBody(constructorBody.toString());
        return annotationLiteral;
    }

    private Map<String, String> extractQualifierMethods(Project project) throws ClassNotFoundException {
        LinkedHashMap<String, String> nameTypeMap = new LinkedHashMap<String, String>();
        String qualifierClassName = (String)this.qualifier.getValue();
        boolean done = false;
        try {
            JavaResource javaResource = ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).getJavaResource(qualifierClassName);
            if (javaResource.exists()) {
                done = true;
                if (!javaResource.getJavaType().isAnnotation()) {
                    throw new RuntimeException("Specified qualifier is not an annotation: " + qualifierClassName);
                }
                JavaAnnotationSource ann = (JavaAnnotationSource)javaResource.getJavaType();
                for (AnnotationElementSource elem : ann.getAnnotationElements()) {
                    String name = elem.getName();
                    String type = "Class".equals(elem.getType().getName()) ? "Class<?>" : elem.getType().getQualifiedName();
                    nameTypeMap.put(name, type);
                }
            }
        }
        catch (FileNotFoundException | ResourceException javaResource) {
            // empty catch block
        }
        if (!done) {
            try (URLClassLoader loader = ((ClassLoaderFacet)project.getFacet(ClassLoaderFacet.class)).getClassLoader();){
                Class<?> qualifierClass = loader.loadClass(qualifierClassName);
                if (!qualifierClass.isAnnotation()) {
                    throw new RuntimeException("Specified qualifier is not an annotation: " + qualifierClassName);
                }
                for (Method m : qualifierClass.getDeclaredMethods()) {
                    String name = m.getName();
                    String type = m.getReturnType() == Class.class ? "Class<?>" : m.getReturnType().getName();
                    nameTypeMap.put(name, type);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return nameTypeMap;
    }
}

