/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.cdi.ui;

import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.javaee.cdi.ui.AbstractCDICommand;
import org.jboss.forge.addon.parser.java.converters.PackageRootConverter;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class CDINewInterceptorCommand
extends AbstractCDICommand<JavaClassSource> {
    @Inject
    @WithAttributes(label="Interceptor Binding", required=true)
    private UIInput<String> interceptorBinding;

    @Override
    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("CDI: New Interceptor").description("Creates a new CDI Interceptor");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        this.interceptorBinding.setValueConverter((Converter)new PackageRootConverter(this.getProjectFactory(), (UIContextProvider)builder));
        builder.add(this.interceptorBinding);
    }

    protected String getType() {
        return "CDI Interceptor";
    }

    protected Class<JavaClassSource> getSourceType() {
        return JavaClassSource.class;
    }

    public JavaClassSource decorateSource(UIExecutionContext context, Project project, JavaClassSource interceptor) throws Exception {
        interceptor.addImport((String)this.interceptorBinding.getValue());
        interceptor.addAnnotation((String)this.interceptorBinding.getValue());
        interceptor.addAnnotation(Interceptor.class);
        interceptor.addImport(InvocationContext.class);
        ((MethodSource)((MethodSource)interceptor.addMethod().setName("intercept")).setParameters("InvocationContext ic").setReturnType(Object.class).setPrivate()).addThrows(Exception.class).setBody("try {\n            return ic.proceed();\n        } finally {\n        }").addAnnotation(AroundInvoke.class);
        return interceptor;
    }
}

