/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.cdi.ui;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.inject.Inject;
import javax.inject.Qualifier;
import org.jboss.forge.addon.javaee.cdi.ui.AbstractCDICommand;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.roaster.model.source.JavaAnnotationSource;

public class CDINewQualifierCommand
extends AbstractCDICommand<JavaAnnotationSource> {
    @Inject
    @WithAttributes(label="Inherited")
    private UIInput<Boolean> inherited;

    @Override
    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("CDI: New Qualifier").description("Creates a new CDI Qualifier annotation");
    }

    protected String getType() {
        return "CDI Qualifier";
    }

    protected Class<JavaAnnotationSource> getSourceType() {
        return JavaAnnotationSource.class;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        builder.add(this.inherited);
    }

    public JavaAnnotationSource decorateSource(UIExecutionContext context, Project project, JavaAnnotationSource qualifier) throws Exception {
        qualifier.addAnnotation(Qualifier.class);
        if (((Boolean)this.inherited.getValue()).booleanValue()) {
            qualifier.addAnnotation(Inherited.class);
        }
        qualifier.addAnnotation(Retention.class).setEnumValue(new Enum[]{RetentionPolicy.RUNTIME});
        qualifier.addAnnotation(Target.class).setEnumValue(new Enum[]{ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.TYPE});
        qualifier.addAnnotation(Documented.class);
        return qualifier;
    }
}

