/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.cdi.ui;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Stereotype;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.forge.addon.javaee.cdi.ui.AbstractCDICommand;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.util.Iterators;
import org.jboss.forge.roaster.model.source.JavaAnnotationSource;

public class CDINewStereotypeCommand
extends AbstractCDICommand<JavaAnnotationSource> {
    @Inject
    @WithAttributes(label="Inherited")
    private UIInput<Boolean> inherited;
    @Inject
    @WithAttributes(label="Alternative")
    private UIInput<Boolean> alternative;
    @Inject
    @WithAttributes(label="Named")
    private UIInput<Boolean> withNamed;
    @Inject
    @WithAttributes(label="Target Element Types", required=true, requiredMessage="No target element types selected")
    private UISelectMany<ElementType> targetTypes;

    @Override
    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("CDI: New Stereotype").description("Creates a new CDI Stereotype annotation");
    }

    protected String getType() {
        return "CDI Stereotype";
    }

    protected Class<JavaAnnotationSource> getSourceType() {
        return JavaAnnotationSource.class;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        this.targetTypes.setValue(Arrays.asList(ElementType.TYPE, ElementType.METHOD, ElementType.FIELD));
        builder.add(this.alternative).add(this.withNamed).add(this.inherited).add(this.targetTypes);
    }

    public JavaAnnotationSource decorateSource(UIExecutionContext context, Project project, JavaAnnotationSource stereotype) throws Exception {
        stereotype.addAnnotation(Stereotype.class);
        if (((Boolean)this.inherited.getValue()).booleanValue()) {
            stereotype.addAnnotation(Inherited.class);
        }
        if (((Boolean)this.withNamed.getValue()).booleanValue()) {
            stereotype.addAnnotation(Named.class);
        }
        if (((Boolean)this.alternative.getValue()).booleanValue()) {
            stereotype.addAnnotation(Alternative.class);
        }
        stereotype.addAnnotation(Retention.class).setEnumValue(new Enum[]{RetentionPolicy.RUNTIME});
        List types = Iterators.asList((Iterable)this.targetTypes.getValue());
        stereotype.addAnnotation(Target.class).setEnumValue((Enum[])types.toArray(new ElementType[types.size()]));
        stereotype.addAnnotation(Documented.class);
        return stereotype;
    }
}

