/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.cdi.ui.input;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import javax.inject.Inject;
import org.jboss.forge.addon.javaee.cdi.CDIOperations;
import org.jboss.forge.addon.javaee.cdi.ui.input.Qualifiers;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.Projects;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.AbstractUIInputManyDecorator;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.roaster.model.source.JavaSource;

public class QualifiersImpl
extends AbstractUIInputManyDecorator<String>
implements Qualifiers {
    @Inject
    @WithAttributes(label="Qualifiers", description="The qualifiers added to the injection point", type="org.jboss.forge.inputType.JAVA_CLASS_PICKER")
    private UIInputMany<String> qualifiers;
    @Inject
    private ProjectFactory projectFactory;
    @Inject
    private CDIOperations cdiOperations;

    protected UIInputMany<String> createDelegate() {
        this.qualifiers.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                Project project = Projects.getSelectedProject((ProjectFactory)QualifiersImpl.this.projectFactory, (UIContext)context);
                ArrayList<String> options = new ArrayList<String>();
                for (String type : CDIOperations.DEFAULT_QUALIFIERS) {
                    if (!Strings.isNullOrEmpty((String)value) && !type.startsWith(value)) continue;
                    options.add(type);
                }
                if (project != null) {
                    for (JavaResource resource : QualifiersImpl.this.cdiOperations.getProjectQualifiers(project)) {
                        try {
                            JavaSource javaSource = (JavaSource)resource.getJavaType();
                            String qualifiedName = javaSource.getQualifiedName();
                            if (!Strings.isNullOrEmpty((String)value) && !qualifiedName.startsWith(value)) continue;
                            options.add(qualifiedName);
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                    }
                }
                return options;
            }
        });
        return this.qualifiers;
    }
}

