/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.ejb.ui;

import java.util.ArrayList;
import javax.inject.Inject;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.javaee.ejb.EJBOperations;
import org.jboss.forge.addon.javaee.ejb.JMSDestinationType;
import org.jboss.forge.addon.javaee.jms.JMSFacet;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;

public class NewMDBSetupStep
extends AbstractJavaEECommand
implements UIWizardStep {
    @Inject
    EJBOperations operations;
    @Inject
    private FacetFactory facetFactory;
    @Inject
    @WithAttributes(required=true, label="JMS Version", defaultValue="1.1")
    private UISelectOne<JMSFacet> jmsVersion;
    @Inject
    @WithAttributes(label="JMS Destination Type", required=true)
    private UISelectOne<JMSDestinationType> destType;
    @Inject
    @WithAttributes(label="JMS Destination Name", required=true)
    private UIInput<String> destName;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("MDB Configuration").description("Specify Message Driven Bean attributes for new EJB.").category(Categories.create((String[])new String[]{"EJB", "Message Driven Beans"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.destType.setDefaultValue((Object)JMSDestinationType.QUEUE);
        Project project = this.getSelectedProject((UIContextProvider)builder);
        if (project.hasFacet(JMSFacet.class)) {
            ((UISelectOne)this.jmsVersion.setEnabled(false)).setValue((Object)project.getFacet(JMSFacet.class));
        }
        builder.add(this.jmsVersion).add(this.destName).add(this.destType);
    }

    public void validate(UIValidationContext context) {
    }

    public Result execute(UIExecutionContext context) throws Exception {
        ArrayList<Result> results = new ArrayList<Result>();
        if (this.jmsVersion.isEnabled() && this.facetFactory.install((Faceted)this.getSelectedProject((UIContextProvider)context), (Facet)this.jmsVersion.getValue())) {
            results.add(Results.success((String)"JMS has been installed."));
        }
        JavaResource ejbResource = (JavaResource)context.getUIContext().getAttributeMap().get(JavaResource.class);
        JavaClassSource ejb = this.operations.setupMessageDrivenBean((JavaClassSource)ejbResource.getJavaType(), (JMSDestinationType)((Object)this.destType.getValue()), (String)this.destName.getValue());
        ejbResource.setContents((JavaSource)ejb);
        results.add(Results.success((String)"Configured Message Driven EJB."));
        return Results.aggregate(results);
    }

    public boolean isEnabled(UIContext context) {
        return true;
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        return null;
    }

    protected boolean isProjectRequired() {
        return true;
    }
}

