/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.faces;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.ProjectStage;
import org.jboss.forge.addon.javaee.AbstractJavaEEFacet;
import org.jboss.forge.addon.javaee.Descriptors;
import org.jboss.forge.addon.javaee.faces.FacesFacet;
import org.jboss.forge.addon.javaee.servlet.ServletFacet;
import org.jboss.forge.addon.javaee.servlet.ServletFacet_2_5;
import org.jboss.forge.addon.javaee.servlet.ServletFacet_3_0;
import org.jboss.forge.addon.javaee.util.ServletUtil;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.furnace.util.Streams;
import org.jboss.forge.parser.xml.Node;
import org.jboss.forge.parser.xml.XMLParser;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImporter;
import org.jboss.shrinkwrap.descriptor.api.javaee.ParamValueCommonType;
import org.jboss.shrinkwrap.descriptor.api.webapp.WebAppCommonDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webapp31.WebAppDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webcommon.ServletMappingCommonType;

public abstract class AbstractFacesFacetImpl<DESCRIPTOR extends Descriptor>
extends AbstractJavaEEFacet
implements FacesFacet<DESCRIPTOR> {
    private static final String FACELETS_VIEW_MAPPINGS = "javax.faces.FACELETS_VIEW_MAPPINGS";
    private static final String FACES_SERVLET_NAME = "Faces Facet";
    private static final String JAVAX_FACES_DEFAULT_SUFFIX = "javax.faces.DEFAULT_SUFFIX";
    private final ServletMappingHelper helper = new ServletMappingHelper();

    public AbstractFacesFacetImpl(DependencyInstaller installer) {
        super(installer);
    }

    public String getSpecName() {
        return "JavaServer Faces";
    }

    @Override
    public boolean isInstalled() {
        boolean active = false;
        String packagingType = ((PackagingFacet)((Project)this.getFaceted()).getFacet(PackagingFacet.class)).getPackagingType();
        active = packagingType.equalsIgnoreCase("war") ? this.getConfigFile().exists() || ((Project)this.getFaceted()).hasFacet(ServletFacet_3_0.class) || this.hasServletMapping() : true;
        return super.isInstalled() && active;
    }

    private boolean hasServletMapping() {
        if (((Project)this.getFaceted()).hasFacet(ServletFacet.class)) {
            ServletFacet servlet = (ServletFacet)((Project)this.getFaceted()).getFacet(ServletFacet.class);
            List mappings = ((WebAppCommonDescriptor)servlet.getConfig()).getAllServletMapping();
            for (ServletMappingCommonType mapping : mappings) {
                if (!FACES_SERVLET_NAME.equals(mapping.getServletName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean install() {
        if (!this.isInstalled()) {
            FileResource<?> descriptor;
            String packagingType = ((PackagingFacet)((Project)this.getFaceted()).getFacet(PackagingFacet.class)).getPackagingType();
            if (packagingType.equalsIgnoreCase("war") && !(descriptor = this.getConfigFile()).exists()) {
                this.createDefaultConfig(descriptor);
            }
            if (!((Project)this.getFaceted()).hasFacet(ServletFacet_3_0.class) && ((Project)this.getFaceted()).hasFacet(ServletFacet_2_5.class) && !this.hasServletMapping()) {
                this.setFacesMapping("*.xhtml");
            }
        }
        return super.install();
    }

    public DESCRIPTOR getConfig() {
        Descriptor descriptor;
        FileResource<?> configFile = this.getConfigFile();
        if (configFile.exists()) {
            DescriptorImporter importer = Descriptors.importAs(this.getDescriptorClass());
            descriptor = importer.fromStream(configFile.getResourceInputStream());
        } else {
            descriptor = Descriptors.create(this.getDescriptorClass());
        }
        return (DESCRIPTOR)descriptor;
    }

    protected abstract Class<DESCRIPTOR> getDescriptorClass();

    public FileResource<?> getConfigFile() {
        Project project = (Project)this.getFaceted();
        PackagingFacet packaging = (PackagingFacet)project.getFacet(PackagingFacet.class);
        if ("war".equals(packaging.getPackagingType())) {
            DirectoryResource webRoot = ((WebResourcesFacet)project.getFacet(WebResourcesFacet.class)).getWebRootDirectory();
            return (FileResource)webRoot.getChild("WEB-INF" + File.separator + "faces-config.xml");
        }
        DirectoryResource root = ((ResourcesFacet)project.getFacet(ResourcesFacet.class)).getResourceDirectory();
        return (FileResource)root.getChild("META-INF" + File.separator + "faces-config.xml");
    }

    public ProjectStage getProjectStage() {
        if (((Project)this.getFaceted()).hasFacet(ServletFacet.class)) {
            ServletFacet servlet = (ServletFacet)((Project)this.getFaceted()).getFacet(ServletFacet.class);
            WebAppCommonDescriptor config = (WebAppCommonDescriptor)servlet.getConfig();
            List params = config.getAllContextParam();
            for (ParamValueCommonType param : params) {
                if (!"javax.faces.PROJECT_STAGE".equals(param.getParamName())) continue;
                return (ProjectStage)ProjectStage.valueOf(ProjectStage.class, (String)param.getParamValue());
            }
        }
        return ProjectStage.Production;
    }

    public void setProjectStage(ProjectStage projectStage) {
        if (((Project)this.getFaceted()).hasFacet(ServletFacet.class)) {
            ServletFacet servlet = (ServletFacet)((Project)this.getFaceted()).getFacet(ServletFacet.class);
            WebAppCommonDescriptor config = (WebAppCommonDescriptor)servlet.getConfig();
            List params = config.getAllContextParam();
            ParamValueCommonType projectStageParam = null;
            for (ParamValueCommonType param : params) {
                if (!"javax.faces.PROJECT_STAGE".equals(param.getParamName())) continue;
                projectStageParam = param;
                break;
            }
            if (projectStageParam == null) {
                projectStageParam = config.createContextParam();
                projectStageParam.paramName("javax.faces.PROJECT_STAGE");
            }
            projectStageParam.paramValue(projectStage.toString());
            servlet.saveConfig((Object)config);
        }
    }

    public List<String> getFacesServletMappings() {
        return this.getExplicitFacesServletMappings();
    }

    public List<String> getEffectiveFacesServletMappings() {
        ArrayList<String> results = new ArrayList<String>();
        ServletFacet servlet = (ServletFacet)((Project)this.getFaceted()).getFacet(ServletFacet.class);
        WebAppCommonDescriptor webXml = (WebAppCommonDescriptor)servlet.getConfig();
        results.addAll(this.getExplicitFacesServletMappings());
        if (results.isEmpty() && (webXml instanceof org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor || webXml instanceof WebAppDescriptor)) {
            results.add("*.jsf");
            results.add("/faces/*");
        }
        return results;
    }

    private List<String> getExplicitFacesServletMappings() {
        ServletFacet servletFacet = (ServletFacet)((Project)this.getFaceted()).getFacet(ServletFacet.class);
        ArrayList<String> results = new ArrayList<String>();
        for (ServletMappingCommonType mapping : ((WebAppCommonDescriptor)servletFacet.getConfig()).getAllServletMapping()) {
            if (!mapping.getServletName().equals(FACES_SERVLET_NAME)) continue;
            results.addAll(mapping.getAllUrlPattern());
        }
        return results;
    }

    public void setFacesMapping(String mapping) {
        InputStream newWebXml;
        ServletFacet facet = (ServletFacet)((Project)this.getFaceted()).getFacet(ServletFacet.class);
        InputStream webXml = facet.getConfigFile().getResourceInputStream();
        if (webXml != (newWebXml = this.helper.addFacesServletMapping(webXml, mapping))) {
            facet.getConfigFile().setContents(newWebXml);
        }
        Streams.closeQuietly((Closeable)webXml);
        Streams.closeQuietly((Closeable)newWebXml);
    }

    public List<String> getWebPaths(Resource<?> r) {
        if (r != null) {
            WebResourcesFacet web = (WebResourcesFacet)((Project)this.getFaceted()).getFacet(WebResourcesFacet.class);
            List webRootDirectories = web.getWebRootDirectories();
            for (DirectoryResource d : webRootDirectories) {
                if (!r.getFullyQualifiedName().startsWith(d.getFullyQualifiedName())) continue;
                String path = r.getFullyQualifiedName().substring(d.getFullyQualifiedName().length());
                path = path.replace(File.separator, "/");
                return this.getWebPaths(path);
            }
        }
        return new ArrayList<String>();
    }

    public List<String> getWebPaths(String path) {
        ArrayList<String> results = new ArrayList<String>();
        if (this.getResourceForWebPath(path) == null) {
            List<String> mappings = this.getEffectiveFacesServletMappings();
            for (String mapping : mappings) {
                String viewId = this.buildFacesViewId(mapping, path);
                if (results.contains(viewId)) continue;
                results.add(viewId);
            }
        }
        return results;
    }

    public Resource<?> getResourceForWebPath(String path) {
        if (path != null) {
            WebResourcesFacet web = (WebResourcesFacet)((Project)this.getFaceted()).getFacet(WebResourcesFacet.class);
            List webRootDirectories = web.getWebRootDirectories();
            boolean matches = false;
            for (String mapping : this.getEffectiveFacesServletMappings()) {
                Matcher matcher = ServletUtil.mappingToRegex(mapping).matcher(path);
                if (!matcher.matches()) continue;
                path = matcher.group(1);
                matches = true;
                break;
            }
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!matches) {
                return null;
            }
            List<String> strings = Arrays.asList(path.split("/"));
            for (DirectoryResource d : webRootDirectories) {
                Resource child;
                LinkedList<String> queue = new LinkedList<String>();
                queue.addAll(strings);
                DirectoryResource temp = d;
                while (queue.size() > 1 && (child = temp.getChild((String)queue.remove())) != null && child.exists()) {
                    temp = child;
                    if (!queue.isEmpty()) continue;
                    return child;
                }
                if (temp == null) continue;
                String name = (String)queue.remove();
                for (String suffix : this.getFacesSuffixes()) {
                    Resource child2 = null;
                    child2 = name.endsWith(suffix) ? temp.getChild(name) : temp.getChild(name + suffix);
                    if (child2 == null || !child2.exists()) continue;
                    return child2;
                }
            }
        }
        return null;
    }

    private String buildFacesViewId(String servletMapping, String resourcePath) {
        for (String suffix : this.getFacesSuffixes()) {
            if (!resourcePath.endsWith(suffix)) continue;
            StringBuffer result = new StringBuffer();
            HashMap<Pattern, String> patterns = new HashMap<Pattern, String>();
            Pattern pathMapping = Pattern.compile("^(/.*)/\\*$");
            Pattern extensionMapping = Pattern.compile("^\\*(\\..*)$");
            Pattern defaultMapping = Pattern.compile("^/\\*$");
            patterns.put(pathMapping, "$1" + resourcePath);
            patterns.put(extensionMapping, resourcePath.replaceAll("^(.*)(\\.\\w+)$", "$1") + "$1");
            patterns.put(defaultMapping, resourcePath);
            boolean matched = false;
            Iterator iterator = patterns.keySet().iterator();
            while (!matched && iterator.hasNext()) {
                Pattern p = (Pattern)iterator.next();
                Matcher m = p.matcher(servletMapping);
                if (!m.matches()) continue;
                String replacement = (String)patterns.get(p);
                m.appendReplacement(result, replacement);
                matched = true;
            }
            if (!matched) {
                return null;
            }
            return result.toString();
        }
        return resourcePath;
    }

    public List<String> getFacesSuffixes() {
        ArrayList<String> suffixes = new ArrayList<String>();
        if (((Project)this.getFaceted()).hasFacet(ServletFacet.class)) {
            ServletFacet servlet = (ServletFacet)((Project)this.getFaceted()).getFacet(ServletFacet.class);
            WebAppCommonDescriptor config = (WebAppCommonDescriptor)servlet.getConfig();
            List params = config.getAllContextParam();
            for (ParamValueCommonType param : params) {
                if (!JAVAX_FACES_DEFAULT_SUFFIX.equals(param.getParamName())) continue;
                suffixes.add(param.getParamValue());
            }
        }
        if (suffixes.isEmpty()) {
            suffixes.add(".xhtml");
        }
        return suffixes;
    }

    public List<String> getFaceletsDefaultSuffixes() {
        return Arrays.asList(".xhtml");
    }

    public List<String> getFaceletsViewMappings() {
        ArrayList<String> suffixes = new ArrayList<String>();
        if (((Project)this.getFaceted()).hasFacet(ServletFacet.class)) {
            ServletFacet servlet = (ServletFacet)((Project)this.getFaceted()).getFacet(ServletFacet.class);
            WebAppCommonDescriptor config = (WebAppCommonDescriptor)servlet.getConfig();
            List params = config.getAllContextParam();
            for (ParamValueCommonType param : params) {
                if (!FACELETS_VIEW_MAPPINGS.equals(param.getParamName())) continue;
                suffixes.add(param.getParamValue());
            }
        }
        if (suffixes.isEmpty()) {
            suffixes.add(".xhtml");
        }
        return suffixes;
    }

    protected abstract void createDefaultConfig(FileResource<?> var1);

    public static class ServletMappingHelper {
        public static final String FACES_SERVLET_CLASS = "javax.faces.webapp.FacesServlet";

        public InputStream addFacesServletMapping(InputStream webXmlStream, String mapping) {
            Node facesServlet;
            Node root = XMLParser.parse((InputStream)webXmlStream);
            boolean mappingCreated = this.createMappingIfNotExists(root, facesServlet = this.getOrCreateFacesServlet(root), mapping);
            if (mappingCreated) {
                return XMLParser.toXMLInputStream((Node)root);
            }
            return XMLParser.toXMLInputStream((Node)root);
        }

        public Node getOrCreateFacesServlet(Node root) {
            List servlets = root.get("servlet");
            for (Node servlet : servlets) {
                if (!FACES_SERVLET_CLASS.equals(servlet.getSingle("servlet-class").getText())) continue;
                return servlet;
            }
            Node servlet = root.createChild("servlet");
            servlet.createChild("servlet-name").text("Faces Servlet");
            servlet.createChild("servlet-class").text(FACES_SERVLET_CLASS);
            servlet.createChild("load-on-startup").text("1");
            return servlet;
        }

        boolean createMappingIfNotExists(Node root, Node servlet, String mapping) {
            List servletMappings = root.get("servlet-mapping");
            Node servletMappingNode = null;
            String servletName = servlet.getSingle("servlet-name").getText();
            for (Node servletMapping : servletMappings) {
                if (!servletName.equals(servletMapping.getSingle("servlet-name").getText())) continue;
                servletMappingNode = servletMapping;
                List urlPatterns = servletMapping.get("url-pattern");
                for (Node urlPattern : urlPatterns) {
                    if (!mapping.equals(urlPattern.getText())) continue;
                    return false;
                }
            }
            if (servletMappingNode == null) {
                servletMappingNode = root.createChild("servlet-mapping");
                servletMappingNode.createChild("servlet-name").text(servletName);
            }
            servletMappingNode.createChild("url-pattern").text(mapping);
            return true;
        }
    }
}

