/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Embedded;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.jboss.forge.addon.javaee.jpa.JPAFacet;
import org.jboss.forge.addon.javaee.jpa.JPAFieldOperations;
import org.jboss.forge.addon.parser.java.beans.FieldOperations;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.roaster.model.Field;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.util.Refactory;
import org.jboss.forge.roaster.model.util.Types;

public class JPAFieldOperationsImpl
extends FieldOperations
implements JPAFieldOperations {
    public void newOneToOneRelationship(Project project, JavaResource resource, String fieldName, String fieldType, String inverseFieldName, FetchType fetchType, boolean required, Iterable<CascadeType> cascadeTypes) throws FileNotFoundException {
        JavaClassSource fieldEntityClass;
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        JavaClassSource entityClass = this.getJavaClassFrom((Resource<?>)resource);
        if (this.areTypesSame(fieldType, entityClass.getCanonicalName())) {
            fieldEntityClass = entityClass;
        } else {
            fieldEntityClass = this.findEntity(project, fieldType);
            entityClass.addImport((JavaType)fieldEntityClass);
        }
        FieldSource localField = this.addFieldTo(entityClass, fieldEntityClass.getName(), fieldName, new String[]{OneToOne.class.getName()});
        AnnotationSource annotation = localField.getAnnotation(OneToOne.class);
        if (inverseFieldName != null && !inverseFieldName.isEmpty()) {
            FieldSource inverseField = this.addFieldTo(fieldEntityClass, entityClass.getName(), inverseFieldName, new String[]{OneToOne.class.getName()});
            inverseField.getAnnotation(OneToOne.class).setStringValue("mappedBy", localField.getName());
            java.saveJavaSource((JavaSource)fieldEntityClass);
        }
        if (fetchType != null && fetchType != FetchType.EAGER) {
            annotation.setEnumValue("fetch", (Enum)fetchType);
        }
        if (required) {
            annotation.setLiteralValue("optional", "false");
        }
        this.addCascade(cascadeTypes, (AnnotationSource<JavaClassSource>)annotation);
        java.saveJavaSource((JavaSource)entityClass);
    }

    private void addCascade(Iterable<CascadeType> cascadeTypes, AnnotationSource<JavaClassSource> annotation) {
        if (cascadeTypes != null) {
            ArrayList<CascadeType> cascades = new ArrayList<CascadeType>();
            for (CascadeType cascade : cascadeTypes) {
                cascades.add(cascade);
            }
            if (!cascades.isEmpty()) {
                if (cascades.containsAll(EnumSet.range(CascadeType.PERSIST, CascadeType.DETACH))) {
                    cascades.clear();
                    cascades.add(CascadeType.ALL);
                }
                annotation.setEnumArrayValue("cascade", (Enum[])cascades.toArray(new CascadeType[cascades.size()]));
            }
        }
    }

    public void newManyToOneRelationship(Project project, JavaResource resource, String fieldName, String fieldType, String inverseFieldName, FetchType fetchType, boolean required, Iterable<CascadeType> cascadeTypes) throws FileNotFoundException {
        JavaClassSource one;
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        JavaClassSource many = this.getJavaClassFrom((Resource<?>)resource);
        if (this.areTypesSame(fieldType, many.getCanonicalName())) {
            one = many;
        } else {
            one = this.findEntity(project, fieldType);
            many.addImport((JavaType)one);
        }
        if (many.hasField(fieldName)) {
            throw new IllegalStateException("Entity [" + many.getCanonicalName() + "] already has a field named [" + fieldName + "]");
        }
        if (!Strings.isNullOrEmpty((String)inverseFieldName) && one.hasField(inverseFieldName)) {
            throw new IllegalStateException("Entity [" + one.getCanonicalName() + "] already has a field named [" + inverseFieldName + "]");
        }
        FieldSource manyField = many.addField("private " + one.getName() + " " + fieldName + ";");
        AnnotationSource manyAnnotation = manyField.addAnnotation(ManyToOne.class);
        Refactory.createGetterAndSetter((JavaClassSource)many, (FieldSource)manyField);
        if (!Strings.isNullOrEmpty((String)inverseFieldName)) {
            one.addImport(Set.class);
            one.addImport(HashSet.class);
            if (!one.getCanonicalName().equals(many.getCanonicalName())) {
                one.addImport(many.getQualifiedName());
            }
            FieldSource oneField = one.addField("private Set<" + many.getName() + "> " + inverseFieldName + "= new HashSet<" + many.getName() + ">();");
            AnnotationSource oneAnnotation = oneField.addAnnotation(OneToMany.class).setStringValue("mappedBy", fieldName);
            oneAnnotation.setLiteralValue("cascade", "CascadeType.ALL");
            ((JavaClassSource)oneAnnotation.getOrigin()).addImport(CascadeType.class);
            Refactory.createGetterAndSetter((JavaClassSource)one, (FieldSource)oneField);
            java.saveJavaSource((JavaSource)one);
        }
        if (fetchType != null && fetchType != FetchType.EAGER) {
            manyAnnotation.setEnumValue("fetch", (Enum)fetchType);
        }
        if (required) {
            manyAnnotation.setLiteralValue("optional", "false");
        }
        this.addCascade(cascadeTypes, (AnnotationSource<JavaClassSource>)manyAnnotation);
        java.saveJavaSource((JavaSource)many);
    }

    public void newEmbeddedRelationship(Project project, JavaResource resource, String fieldName, String fieldType) throws FileNotFoundException {
        JavaClassSource fieldEntityClass;
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        JavaClassSource entityClass = this.getJavaClassFrom((Resource<?>)resource);
        if (this.areTypesSame(fieldType, entityClass.getCanonicalName())) {
            fieldEntityClass = entityClass;
        } else {
            fieldEntityClass = this.findEntity(project, fieldType);
            entityClass.addImport((JavaType)fieldEntityClass);
        }
        this.addFieldTo(entityClass, fieldEntityClass.getName(), fieldName, new String[]{Embedded.class.getName()});
        java.saveJavaSource((JavaSource)entityClass);
    }

    public void newOneToManyRelationship(Project project, JavaResource resource, String fieldName, String fieldType, String inverseFieldName, FetchType fetchType, Iterable<CascadeType> cascadeTypes) throws FileNotFoundException {
        JavaClassSource many;
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        JavaClassSource one = this.getJavaClassFrom((Resource<?>)resource);
        if (this.areTypesSame(fieldType, one.getCanonicalName())) {
            many = one;
        } else {
            many = this.findEntity(project, fieldType);
            one.addImport(many.getQualifiedName());
        }
        if (one.hasField(fieldName)) {
            throw new IllegalStateException("Entity [" + one.getCanonicalName() + "] already has a field named [" + fieldName + "]");
        }
        if (!Strings.isNullOrEmpty((String)inverseFieldName) && many.hasField(inverseFieldName)) {
            throw new IllegalStateException("Entity [" + many.getCanonicalName() + "] already has a field named [" + inverseFieldName + "]");
        }
        one.addImport(Set.class);
        one.addImport(HashSet.class);
        FieldSource oneField = one.addField("private Set<" + many.getName() + "> " + fieldName + "= new HashSet<" + many.getName() + ">();");
        AnnotationSource annotation = oneField.addAnnotation(OneToMany.class);
        Refactory.createGetterAndSetter((JavaClassSource)one, (FieldSource)oneField);
        if (!Strings.isNullOrEmpty((String)inverseFieldName)) {
            annotation.setStringValue("mappedBy", inverseFieldName);
            annotation.setLiteralValue("cascade", "CascadeType.ALL");
            ((JavaClassSource)annotation.getOrigin()).addImport(CascadeType.class);
            annotation.setLiteralValue("orphanRemoval", "true");
            if (!many.getCanonicalName().equals(one.getCanonicalName())) {
                many.addImport((JavaType)one);
            }
            FieldSource manyField = many.addField("private " + one.getName() + " " + inverseFieldName + ";");
            manyField.addAnnotation(ManyToOne.class);
            Refactory.createGetterAndSetter((JavaClassSource)many, (FieldSource)manyField);
            java.saveJavaSource((JavaSource)many);
        }
        if (fetchType != null && fetchType != FetchType.LAZY) {
            annotation.setEnumValue("fetch", (Enum)fetchType);
        }
        this.addCascade(cascadeTypes, (AnnotationSource<JavaClassSource>)annotation);
        java.saveJavaSource((JavaSource)one);
    }

    public void newManyToManyRelationship(Project project, JavaResource resource, String fieldName, String fieldType, String inverseFieldName, FetchType fetchType, Iterable<CascadeType> cascadeTypes) throws FileNotFoundException {
        JavaClassSource otherEntity;
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        JavaClassSource entity = this.getJavaClassFrom((Resource<?>)resource);
        if (this.areTypesSame(fieldType, entity.getCanonicalName())) {
            otherEntity = entity;
        } else {
            otherEntity = this.findEntity(project, fieldType);
            entity.addImport(otherEntity.getQualifiedName());
        }
        if (entity.hasField(fieldName)) {
            throw new IllegalStateException("Entity [" + entity.getCanonicalName() + "] already has a field named [" + fieldName + "]");
        }
        if (!Strings.isNullOrEmpty((String)inverseFieldName) && otherEntity.hasField(inverseFieldName)) {
            throw new IllegalStateException("Entity [" + otherEntity.getCanonicalName() + "] already has a field named [" + inverseFieldName + "]");
        }
        entity.addImport(Set.class);
        entity.addImport(HashSet.class);
        FieldSource field = entity.addField("private Set<" + otherEntity.getName() + "> " + fieldName + "= new HashSet<" + otherEntity.getName() + ">();");
        AnnotationSource annotation = field.addAnnotation(ManyToMany.class);
        Refactory.createGetterAndSetter((JavaClassSource)entity, (FieldSource)field);
        if (!Strings.isNullOrEmpty((String)inverseFieldName)) {
            annotation.setStringValue("mappedBy", inverseFieldName);
            otherEntity.addImport(Set.class);
            otherEntity.addImport(HashSet.class);
            if (!otherEntity.getCanonicalName().equals(entity.getCanonicalName())) {
                otherEntity.addImport(entity.getQualifiedName());
            }
            FieldSource otherField = otherEntity.addField("private Set<" + entity.getName() + "> " + inverseFieldName + "= new HashSet<" + entity.getName() + ">();");
            otherField.addAnnotation(ManyToMany.class);
            Refactory.createGetterAndSetter((JavaClassSource)otherEntity, (FieldSource)otherField);
            java.saveJavaSource((JavaSource)otherEntity);
        }
        if (fetchType != null && fetchType != FetchType.LAZY) {
            annotation.setEnumValue("fetch", (Enum)fetchType);
        }
        this.addCascade(cascadeTypes, (AnnotationSource<JavaClassSource>)annotation);
        java.saveJavaSource((JavaSource)entity);
    }

    private JavaClassSource findEntity(Project project, String entity) throws FileNotFoundException {
        JavaClassSource result = null;
        JPAFacet persistence = (JPAFacet)project.getFacet(JPAFacet.class);
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        if (entity != null && (result = this.getJavaClassFrom((Resource<?>)java.getJavaResource(entity))) == null) {
            result = this.getJavaClassFrom((Resource<?>)java.getJavaResource(persistence.getEntityPackage() + "." + entity));
        }
        if (result == null) {
            throw new FileNotFoundException("Could not locate JavaClass on which to operate.");
        }
        return result;
    }

    private JavaClassSource getJavaClassFrom(Resource<?> resource) throws FileNotFoundException {
        JavaSource source = (JavaSource)((JavaResource)resource).getJavaType();
        if (!(source instanceof JavaClassSource)) {
            throw new IllegalStateException("Current resource is not a JavaClass!");
        }
        return (JavaClassSource)source;
    }

    private boolean areTypesSame(String from, String to) {
        String fromCompare = from.endsWith(".java") ? from.substring(0, from.length() - 5) : from;
        String toCompare = to.endsWith(".java") ? to.substring(0, to.length() - 5) : to;
        return fromCompare.equals(toCompare);
    }

    protected boolean canAddFieldToToString(Field<JavaClassSource> field) {
        return super.canAddFieldToToString(field) && (field.getType().isPrimitive() || Types.isJavaLang((String)field.getType().getQualifiedName())) && !"id".equals(field.getName()) && !"version".equals(field.getName()) && !field.hasAnnotation(Transient.class);
    }
}

