/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa.dao.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.persistence.Id;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.javaee.ejb.EJBFacet;
import org.jboss.forge.addon.javaee.ejb.ui.EJBSetupWizardImpl;
import org.jboss.forge.addon.javaee.jpa.JPAFacet;
import org.jboss.forge.addon.javaee.jpa.dao.DaoGenerationContext;
import org.jboss.forge.addon.javaee.jpa.dao.DaoResourceGenerator;
import org.jboss.forge.addon.javaee.jpa.ui.setup.JPASetupWizard;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.command.PrerequisiteCommandsProvider;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICategory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.roaster.model.Member;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.shrinkwrap.descriptor.api.persistence.PersistenceCommonDescriptor;
import org.jboss.shrinkwrap.descriptor.api.persistence.PersistenceUnitCommon;

public class DaoFromEntityCommand
extends AbstractJavaEECommand
implements PrerequisiteCommandsProvider {
    @Inject
    @WithAttributes(label="Targets", required=true)
    private UISelectMany<JavaClassSource> targets;
    @Inject
    @WithAttributes(label="Generator", required=true)
    private UISelectOne<DaoResourceGenerator> generator;
    @Inject
    @WithAttributes(label="Persistence Unit", required=true)
    private UISelectOne<String> persistenceUnit;
    @Inject
    @WithAttributes(label="Target Package Name", required=true, type="org.jboss.forge.inputType.JAVA_PACKAGE_PICKER")
    private UIInput<String> packageName;
    @Inject
    @WithAttributes(label="Overwrite existing classes?", enabled=false, defaultValue="false")
    private UIInput<Boolean> overwrite;
    @Inject
    private DaoResourceGenerator defaultResourceGenerator;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("JPA: Generate DAOs From Entities").description("Generate DAOs from JPA entities").category(Categories.create((UICategory)super.getMetadata(context).getCategory(), (String[])new String[]{"JPA"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        UIContext context = builder.getUIContext();
        Project project = this.getSelectedProject(context);
        JPAFacet persistenceFacet = (JPAFacet)project.getFacet(JPAFacet.class);
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        List allEntities = persistenceFacet.getAllEntities();
        ArrayList<JavaClassSource> supportedEntities = new ArrayList<JavaClassSource>();
        for (JavaClassSource entity : allEntities) {
            if (!this.isEntityWithSimpleKey(entity)) continue;
            supportedEntities.add(entity);
        }
        this.targets.setValueChoices(supportedEntities);
        this.targets.setItemLabelConverter((Converter)new Converter<JavaClassSource, String>(){

            public String convert(JavaClassSource source) {
                return source == null ? null : source.getQualifiedName();
            }
        });
        ArrayList<String> persistenceUnits = new ArrayList<String>();
        List allUnits = ((PersistenceCommonDescriptor)persistenceFacet.getConfig()).getAllPersistenceUnit();
        for (PersistenceUnitCommon persistenceUnit : allUnits) {
            persistenceUnits.add(persistenceUnit.getName());
        }
        if (!persistenceUnits.isEmpty()) {
            ((UISelectOne)this.persistenceUnit.setValueChoices(persistenceUnits)).setDefaultValue(persistenceUnits.get(0));
        }
        this.packageName.setDefaultValue((Object)(javaSourceFacet.getBasePackage() + ".dao"));
        this.generator.setDefaultValue((Object)this.defaultResourceGenerator);
        if (context.getProvider().isGUI()) {
            this.generator.setItemLabelConverter((Converter)new Converter<DaoResourceGenerator, String>(){

                public String convert(DaoResourceGenerator source) {
                    return source == null ? null : source.getDescription();
                }
            });
        } else {
            this.generator.setItemLabelConverter((Converter)new Converter<DaoResourceGenerator, String>(){

                public String convert(DaoResourceGenerator source) {
                    return source == null ? null : source.getName();
                }
            });
        }
        builder.add(this.targets).add(this.generator).add(this.packageName).add(this.persistenceUnit).add(this.overwrite);
    }

    private boolean isEntityWithSimpleKey(JavaClassSource entity) {
        for (Member member : entity.getMembers()) {
            if (!member.hasAnnotation(Id.class)) continue;
            return true;
        }
        return false;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        UIContext uiContext = context.getUIContext();
        DaoGenerationContext generationContext = this.createContextFor(uiContext);
        Set<JavaClassSource> endpoints = this.generateDaos(generationContext);
        Project project = generationContext.getProject();
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        ArrayList<JavaResource> selection = new ArrayList<JavaResource>();
        for (JavaClassSource javaClass : endpoints) {
            selection.add(javaSourceFacet.saveJavaSource((JavaSource)javaClass));
        }
        uiContext.setSelection(selection);
        return Results.success((String)"Dao created");
    }

    private Set<JavaClassSource> generateDaos(DaoGenerationContext generationContext) throws Exception {
        DaoResourceGenerator selectedGenerator = (DaoResourceGenerator)this.generator.getValue();
        HashSet<JavaClassSource> classes = new HashSet<JavaClassSource>();
        for (JavaClassSource target : this.targets.getValue()) {
            generationContext.setEntity(target);
            List artifacts = selectedGenerator.generateFrom(generationContext);
            classes.addAll(artifacts);
        }
        return classes;
    }

    protected boolean isProjectRequired() {
        return true;
    }

    private DaoGenerationContext createContextFor(UIContext context) {
        DaoGenerationContext generationContext = new DaoGenerationContext();
        generationContext.setProject(this.getSelectedProject(context));
        generationContext.setPersistenceUnitName((String)this.persistenceUnit.getValue());
        generationContext.setTargetPackageName((String)this.packageName.getValue());
        return generationContext;
    }

    public NavigationResult getPrerequisiteCommands(UIContext context) {
        NavigationResultBuilder builder = NavigationResultBuilder.create();
        Project project = this.getSelectedProject(context);
        if (project != null) {
            if (!project.hasFacet(JPAFacet.class)) {
                builder.add(JPASetupWizard.class);
            }
            if (!project.hasFacet(EJBFacet.class)) {
                builder.add(EJBSetupWizardImpl.class);
            }
        }
        return builder.build();
    }
}

