/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa.providers;

import java.util.Collections;
import java.util.List;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.javaee.jpa.JPADataSource;
import org.jboss.forge.addon.javaee.jpa.MetaModelProvider;
import org.jboss.forge.addon.javaee.jpa.PersistenceProvider;
import org.jboss.forge.addon.javaee.jpa.SchemaGenerationType;
import org.jboss.forge.addon.javaee.jpa.providers.HibernateMetaModelProvider;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.shrinkwrap.descriptor.api.persistence.PersistenceCommonDescriptor;
import org.jboss.shrinkwrap.descriptor.api.persistence.PersistenceUnitCommon;
import org.jboss.shrinkwrap.descriptor.api.persistence.PropertiesCommon;

public class JavaEEDefaultProvider
implements PersistenceProvider {
    public String getName() {
        return "Java EE";
    }

    public String getProvider() {
        return null;
    }

    public PersistenceUnitCommon configure(PersistenceUnitCommon unit, JPADataSource ds, Project project) {
        unit.excludeUnlistedClasses(Boolean.FALSE);
        PersistenceCommonDescriptor descriptor = (PersistenceCommonDescriptor)unit.up();
        if (SingleVersion.valueOf((String)descriptor.getVersion()).compareTo((Version)SingleVersion.valueOf((String)"2.1")) >= 0) {
            PropertiesCommon properties = unit.getOrCreateProperties();
            String schemaGenerationPropertyValue = this.getSchemaGenerationPropertyValue(ds.getSchemaGenerationType());
            if (!Strings.isNullOrEmpty((String)schemaGenerationPropertyValue)) {
                properties.createProperty().name("javax.persistence.schema-generation.database.action").value(schemaGenerationPropertyValue);
                properties.createProperty().name("javax.persistence.schema-generation.scripts.action").value(schemaGenerationPropertyValue);
                String createDdlFileName = project == null ? "create.ddl" : this.getProjectName(project) + "Create.ddl";
                properties.createProperty().name("javax.persistence.schema-generation.scripts.create-target").value(createDdlFileName);
                String dropDdlFileName = project == null ? "drop.ddl" : this.getProjectName(project) + "Drop.ddl";
                properties.createProperty().name("javax.persistence.schema-generation.scripts.drop-target").value(dropDdlFileName);
            }
        }
        return unit;
    }

    private String getSchemaGenerationPropertyValue(SchemaGenerationType gen) {
        if (gen == null) {
            return null;
        }
        switch (gen) {
            case DROP_CREATE: {
                return "drop-and-create";
            }
            case CREATE: {
                return "create";
            }
            case DROP: {
                return "drop";
            }
        }
        return null;
    }

    private String getProjectName(Project project) {
        MetadataFacet metadata = (MetadataFacet)project.getFacet(MetadataFacet.class);
        return metadata.getProjectName();
    }

    public List<Dependency> listDependencies() {
        return Collections.emptyList();
    }

    public MetaModelProvider getMetaModelProvider() {
        return new HibernateMetaModelProvider();
    }

    public void validate(JPADataSource dataSource) throws Exception {
    }
}

