/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa.ui;

import javax.inject.Inject;
import javax.persistence.GenerationType;
import org.jboss.forge.addon.javaee.jpa.PersistenceOperations;
import org.jboss.forge.addon.javaee.jpa.ui.AbstractJPACommand;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.roaster.model.source.JavaClassSource;

public class JPANewEntityCommand
extends AbstractJPACommand<JavaClassSource> {
    @Inject
    @WithAttributes(label="ID Column Generation Strategy", defaultValue="AUTO")
    private UISelectOne<GenerationType> idStrategy;
    @Inject
    @WithAttributes(label="Target Directory", required=true)
    private UIInput<DirectoryResource> targetLocation;
    @Inject
    @WithAttributes(label="Table Name")
    private UIInput<String> tableName;
    @Inject
    private PersistenceOperations persistenceOperations;

    @Override
    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("JPA: New Entity").description("Create a new JPA Entity");
    }

    protected String getType() {
        return "JPA Entity";
    }

    protected Class<JavaClassSource> getSourceType() {
        return JavaClassSource.class;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        this.idStrategy.setDefaultValue((Object)GenerationType.AUTO);
        builder.add(this.idStrategy).add(this.tableName);
    }

    public JavaClassSource decorateSource(UIExecutionContext context, Project project, JavaClassSource source) throws Exception {
        GenerationType idStrategyChosen = (GenerationType)this.idStrategy.getValue();
        if (idStrategyChosen == null) {
            idStrategyChosen = GenerationType.AUTO;
        }
        return this.persistenceOperations.newEntity(source, idStrategyChosen, (String)this.tableName.getValue());
    }
}

