/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa.ui;

import java.util.EnumSet;
import java.util.Map;
import javax.inject.Inject;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import org.jboss.forge.addon.javaee.jpa.JPAFieldOperations;
import org.jboss.forge.addon.javaee.jpa.ui.RelationshipType;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;

public class JPANewFieldRelationshipWizardStep
extends AbstractJavaEECommand
implements UIWizardStep {
    @Inject
    @WithAttributes(label="Fetch Type", description="Whether the association should be lazily loaded or must be eagerly fetched", type="org.jboss.forge.inputType.RADIO")
    private UISelectOne<FetchType> fetchType;
    @Inject
    @WithAttributes(label="Inverse Field Name", description="Create a bi-directional relationship, using this value as the name of the inverse field.")
    private UIInput<String> inverseFieldName;
    @Inject
    @WithAttributes(label="Required", description="Is this field required ?", defaultValue="false")
    private UIInput<Boolean> required;
    @Inject
    @WithAttributes(label="Cascade Type", description="Define the set of operations that are cascaded to the target.")
    private UISelectMany<CascadeType> cascadeType;
    @Inject
    private JPAFieldOperations persistenceOperations;

    public void initializeUI(UIBuilder builder) throws Exception {
        UIContext context = builder.getUIContext();
        Map attributeMap = context.getAttributeMap();
        RelationshipType relationship = RelationshipType.valueOf(attributeMap.get(RelationshipType.class).toString());
        this.cascadeType.setValueChoices(EnumSet.range(CascadeType.PERSIST, CascadeType.DETACH));
        boolean shouldAddRequired = false;
        switch (relationship) {
            case MANY_TO_MANY: 
            case ONE_TO_MANY: {
                this.fetchType.setDefaultValue((Object)FetchType.LAZY);
                break;
            }
            case MANY_TO_ONE: 
            case ONE_TO_ONE: {
                this.fetchType.setDefaultValue((Object)FetchType.EAGER);
                shouldAddRequired = true;
                break;
            }
            case EMBEDDED: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Relationship " + (Object)((Object)relationship) + " is not supported");
            }
        }
        builder.add(this.fetchType).add(this.inverseFieldName);
        if (shouldAddRequired) {
            builder.add(this.required);
        }
        builder.add(this.cascadeType);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        UIContext uiContext = context.getUIContext();
        Map attributeMap = uiContext.getAttributeMap();
        JavaResource entity = (JavaResource)attributeMap.get(JavaResource.class);
        String fieldName = (String)attributeMap.get("fieldName");
        String fieldType = (String)attributeMap.get("fieldType");
        Project project = this.getSelectedProject((UIContextProvider)context);
        RelationshipType relationship = RelationshipType.valueOf(attributeMap.get(RelationshipType.class).toString());
        switch (relationship) {
            case MANY_TO_MANY: {
                this.persistenceOperations.newManyToManyRelationship(project, entity, fieldName, fieldType, (String)this.inverseFieldName.getValue(), (FetchType)this.fetchType.getValue(), this.cascadeType.getValue());
                break;
            }
            case MANY_TO_ONE: {
                this.persistenceOperations.newManyToOneRelationship(project, entity, fieldName, fieldType, (String)this.inverseFieldName.getValue(), (FetchType)this.fetchType.getValue(), ((Boolean)this.required.getValue()).booleanValue(), this.cascadeType.getValue());
                break;
            }
            case ONE_TO_MANY: {
                this.persistenceOperations.newOneToManyRelationship(project, entity, fieldName, fieldType, (String)this.inverseFieldName.getValue(), (FetchType)this.fetchType.getValue(), this.cascadeType.getValue());
                break;
            }
            case ONE_TO_ONE: {
                this.persistenceOperations.newOneToOneRelationship(project, entity, fieldName, fieldType, (String)this.inverseFieldName.getValue(), (FetchType)this.fetchType.getValue(), ((Boolean)this.required.getValue()).booleanValue(), this.cascadeType.getValue());
                break;
            }
            case EMBEDDED: {
                this.persistenceOperations.newEmbeddedRelationship(project, entity, fieldName, fieldType);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Relationship " + (Object)((Object)relationship) + " is not supported");
            }
        }
        return Results.success((String)("Relationship " + relationship.getDescription() + " created"));
    }

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("JPA: New Field Relationship").description("Setup the relationship for this field").category(Categories.create((String[])new String[]{super.getMetadata(context).getCategory().getName(), "JPA"}));
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        return null;
    }

    protected boolean isProjectRequired() {
        return false;
    }
}

