/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa.ui;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.javaee.jpa.JPAFacet;
import org.jboss.forge.addon.javaee.jpa.PersistenceOperations;
import org.jboss.forge.addon.javaee.jpa.ui.JPANewFieldRelationshipWizardStep;
import org.jboss.forge.addon.javaee.jpa.ui.RelationshipType;
import org.jboss.forge.addon.javaee.jpa.ui.setup.JPASetupWizard;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.parser.java.beans.FieldOperations;
import org.jboss.forge.addon.parser.java.beans.ProjectOperations;
import org.jboss.forge.addon.parser.java.converters.PackageRootConverter;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.ResourceException;
import org.jboss.forge.addon.ui.command.PrerequisiteCommandsProvider;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIPrompt;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.roaster.model.Field;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;

public class JPANewFieldWizard
extends AbstractJavaEECommand
implements UIWizard,
PrerequisiteCommandsProvider {
    @Inject
    @WithAttributes(label="Target Entity", description="The targetEntity which the field will be created", required=true, type="org.jboss.forge.inputType.DROPDOWN")
    private UISelectOne<JavaResource> targetEntity;
    @Inject
    @WithAttributes(label="Field Name", description="The field name to be created in the target targetEntity", required=true)
    private UIInput<String> named;
    @Inject
    @WithAttributes(name="not-nullable", label="Not Nullable")
    private UIInput<Boolean> notNullable;
    @Inject
    @WithAttributes(name="not-updatable", label="Not Updatable")
    private UIInput<Boolean> notUpdatable;
    @Inject
    @WithAttributes(name="not-insertable", label="Not Insertable")
    private UIInput<Boolean> notInsertable;
    @Inject
    @WithAttributes(label="Field Type", description="The type intended to be used for this field", type="org.jboss.forge.inputType.JAVA_CLASS_PICKER", required=true, defaultValue="String")
    private UIInput<String> type;
    @Inject
    @WithAttributes(label="Relationship Type", description="The relationship type", type="org.jboss.forge.inputType.RADIO")
    private UISelectOne<RelationshipType> relationshipType;
    @Inject
    @WithAttributes(label="Is LOB?", description="If the relationship is a LOB, in this case, it will ignore the value in the Type field", defaultValue="false")
    private UIInput<Boolean> lob;
    @Inject
    @WithAttributes(label="Length", defaultValue="255", description="The column length. (Applies only if a string-valued column is used.)")
    private UIInput<Integer> length;
    @Inject
    @WithAttributes(label="Temporal Type", defaultValue="DATE", description="Adds @Temporal only if field is java.util.Date or java.util.Calendar", type="org.jboss.forge.inputType.RADIO", enabled=false)
    private UISelectOne<TemporalType> temporalType;
    @Inject
    @WithAttributes(label="Column Name", description="The column name. Defaults to the field name")
    private UIInput<String> columnName;
    @Inject
    @WithAttributes(label="Enum Type", defaultValue="ORDINAL", description="Defines mapping for enumerated type. Will be ignored if the type of field is other than enum.", type="org.jboss.forge.inputType.RADIO")
    private UISelectOne<EnumType> enumType;
    @Inject
    @WithAttributes(name="transient", shortName=116, label="Is Transient?", description="Creates a field with @Transient", defaultValue="false")
    private UIInput<Boolean> transientField;
    @Inject
    private FieldOperations beanOperations;
    @Inject
    private PersistenceOperations persistenceOperations;
    @Inject
    private ProjectOperations projectOperations;

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("JPA: New Field").description("Create a new field").category(Categories.create((String[])new String[]{super.getMetadata(context).getCategory().getName(), "JPA"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        final Project project = this.getSelectedProject((UIContextProvider)builder);
        this.setupEntities(builder.getUIContext());
        this.setupRelationshipType();
        final List<String> types = Arrays.asList("byte", "float", "char", "double", "int", "long", "short", "boolean", "String", "java.util.Date");
        this.type.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                ArrayList<String> options = new ArrayList<String>();
                for (String type : types) {
                    if (!Strings.isNullOrEmpty((String)value) && !type.startsWith(value)) continue;
                    options.add(type);
                }
                if (project != null) {
                    String qualifiedName;
                    JavaSource javaSource2;
                    for (JavaResource resource : JPANewFieldWizard.this.persistenceOperations.getProjectEntities(project)) {
                        try {
                            javaSource2 = (JavaSource)resource.getJavaType();
                            qualifiedName = javaSource2.getQualifiedName();
                            if (!Strings.isNullOrEmpty((String)value) && !qualifiedName.startsWith(value)) continue;
                            options.add(qualifiedName);
                        }
                        catch (FileNotFoundException javaSource2) {}
                    }
                    for (JavaResource resource : JPANewFieldWizard.this.projectOperations.getProjectEnums(project)) {
                        try {
                            javaSource2 = (JavaSource)resource.getJavaType();
                            qualifiedName = javaSource2.getQualifiedName();
                            if (!Strings.isNullOrEmpty((String)value) && !qualifiedName.startsWith(value)) continue;
                            options.add(qualifiedName);
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                    }
                }
                return options;
            }
        });
        this.relationshipType.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return !types.contains(JPANewFieldWizard.this.type.getValue()) && (Boolean)JPANewFieldWizard.this.transientField.getValue() == false;
            }
        });
        this.relationshipType.setValueChoices((Callable)new Callable<Iterable<RelationshipType>>(){

            @Override
            public Iterable<RelationshipType> call() throws Exception {
                ArrayList<RelationshipType> options = new ArrayList<RelationshipType>();
                if (project != null) {
                    for (JavaResource resource : JPANewFieldWizard.this.persistenceOperations.getProjectEntities(project)) {
                        try {
                            JavaSource javaSource = (JavaSource)resource.getJavaType();
                            String qualifiedName = javaSource.getQualifiedName();
                            String simpleName = javaSource.getName();
                            if (!qualifiedName.equals(JPANewFieldWizard.this.type.getValue()) && !simpleName.equals(JPANewFieldWizard.this.type.getValue())) continue;
                            if (javaSource.hasAnnotation(Embeddable.class)) {
                                options.add(RelationshipType.EMBEDDED);
                                continue;
                            }
                            options.add(RelationshipType.BASIC);
                            options.add(RelationshipType.ONE_TO_MANY);
                            options.add(RelationshipType.ONE_TO_ONE);
                            options.add(RelationshipType.MANY_TO_MANY);
                            options.add(RelationshipType.MANY_TO_ONE);
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                    }
                }
                if (options.isEmpty()) {
                    for (RelationshipType type : RelationshipType.values()) {
                        options.add(type);
                    }
                }
                return options;
            }
        });
        this.lob.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return JPANewFieldWizard.this.relationshipType.getValue() == RelationshipType.BASIC && (Boolean)JPANewFieldWizard.this.transientField.getValue() == false;
            }
        });
        this.type.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return (Boolean)JPANewFieldWizard.this.lob.getValue() == false && (Boolean)JPANewFieldWizard.this.transientField.getValue() == false;
            }
        });
        this.columnName.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return (Boolean)JPANewFieldWizard.this.transientField.getValue() == false;
            }
        });
        this.notNullable.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return (Boolean)JPANewFieldWizard.this.transientField.getValue() == false;
            }
        });
        this.notInsertable.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return (Boolean)JPANewFieldWizard.this.transientField.getValue() == false;
            }
        });
        this.notUpdatable.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return (Boolean)JPANewFieldWizard.this.transientField.getValue() == false;
            }
        });
        this.length.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return (Boolean)JPANewFieldWizard.this.lob.getValue() == false && (Boolean)JPANewFieldWizard.this.transientField.getValue() == false;
            }
        });
        this.temporalType.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String typeValue = (String)JPANewFieldWizard.this.type.getValue();
                return (Boolean)JPANewFieldWizard.this.transientField.getValue() == false && (Date.class.getName().equals(typeValue) || Calendar.class.getName().equals(typeValue));
            }
        });
        this.enumType.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                JavaClassSource targetEntityType = null;
                if (JPANewFieldWizard.this.targetEntity.getValue() != null) {
                    try {
                        targetEntityType = (JavaClassSource)((JavaResource)JPANewFieldWizard.this.targetEntity.getValue()).getJavaType();
                    }
                    catch (FileNotFoundException | ResourceException throwable) {
                        // empty catch block
                    }
                }
                return (Boolean)JPANewFieldWizard.this.lob.getValue() == false && (Boolean)JPANewFieldWizard.this.transientField.getValue() == false && JPANewFieldWizard.this.beanOperations.isFieldTypeEnum(project, targetEntityType, (String)JPANewFieldWizard.this.type.getValue());
            }
        });
        this.type.setValueConverter((Converter)new PackageRootConverter(this.getProjectFactory(), (UIContextProvider)builder));
        builder.add(this.targetEntity).add(this.named).add(this.type).add(this.temporalType).add(this.columnName).add(this.length).add(this.notNullable).add(this.notInsertable).add(this.notUpdatable).add(this.relationshipType).add(this.lob).add(this.transientField).add(this.enumType);
    }

    private void setupEntities(UIContext context) {
        UISelection selection = context.getInitialSelection();
        Project project = this.getSelectedProject(context);
        List entities = this.persistenceOperations.getProjectEntities(project);
        this.targetEntity.setValueChoices((Iterable)entities);
        int idx = -1;
        if (!selection.isEmpty()) {
            idx = entities.indexOf(selection.get());
        }
        if (idx != -1) {
            this.targetEntity.setDefaultValue(entities.get(idx));
        }
    }

    private void setupRelationshipType() {
        this.relationshipType.setItemLabelConverter((Converter)new Converter<RelationshipType, String>(){

            public String convert(RelationshipType source) {
                return source == null ? null : source.getDescription();
            }
        });
        this.relationshipType.setDefaultValue((Object)RelationshipType.BASIC);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        RelationshipType value;
        String action;
        Project project = this.getSelectedProject((UIContextProvider)context);
        JavaResource javaResource = (JavaResource)this.targetEntity.getValue();
        String fieldNameStr = (String)this.named.getValue();
        JavaClassSource targetEntity = (JavaClassSource)javaResource.getJavaType();
        FieldSource field = targetEntity.getField(fieldNameStr);
        String string = action = field == null ? "created" : "updated";
        if (field != null) {
            UIPrompt prompt = context.getPrompt();
            if (prompt.promptBoolean("Field '" + field.getName() + "' already exists. Do you want to overwrite it?")) {
                this.beanOperations.removeField(targetEntity, (Field)field);
            } else {
                return Results.fail((String)("Field '" + field.getName() + "' already exists."));
            }
        }
        RelationshipType relationshipType = value = this.relationshipType.isEnabled() ? (RelationshipType)((Object)this.relationshipType.getValue()) : RelationshipType.BASIC;
        if (((Boolean)this.transientField.getValue()).booleanValue()) {
            String fieldType = (String)this.type.getValue();
            field = this.beanOperations.addFieldTo(targetEntity, fieldType, fieldNameStr, new String[]{Transient.class.getCanonicalName()});
            this.setCurrentWorkingResource(context, javaResource, (Field<JavaClassSource>)field);
            return Results.success((String)("Transient Field " + (String)this.named.getValue() + " " + action));
        }
        if (value == RelationshipType.BASIC) {
            if (((Boolean)this.lob.getValue()).booleanValue()) {
                String fieldType = (String)this.type.getValue();
                field = this.beanOperations.addFieldTo(targetEntity, fieldType, fieldNameStr, new String[]{Lob.class.getName()});
                field.addAnnotation(Column.class).setLiteralValue("length", String.valueOf(Integer.MAX_VALUE));
            } else if (this.beanOperations.isFieldTypeEnum(project, targetEntity, (String)this.type.getValue())) {
                String fieldType = (String)this.type.getValue();
                field = this.beanOperations.addFieldTo(targetEntity, fieldType, fieldNameStr, new String[]{Enumerated.class.getCanonicalName()});
                if (this.enumType.isEnabled() && this.enumType.getValue() != EnumType.ORDINAL) {
                    field.getAnnotation(Enumerated.class).setEnumArrayValue(new Enum[]{(Enum)this.enumType.getValue()});
                }
                if (this.columnName.isEnabled() && this.columnName.hasValue()) {
                    field.addAnnotation(Column.class).setStringValue("name", (String)this.columnName.getValue());
                }
                if (this.notNullable.isEnabled() && ((Boolean)this.notNullable.getValue()).booleanValue()) {
                    this.setLiteralValueInColumn((FieldSource<JavaClassSource>)field, "nullable", "false");
                }
                if (this.notInsertable.isEnabled() && ((Boolean)this.notInsertable.getValue()).booleanValue()) {
                    this.setLiteralValueInColumn((FieldSource<JavaClassSource>)field, "insertable", "false");
                }
                if (this.notUpdatable.isEnabled() && ((Boolean)this.notUpdatable.getValue()).booleanValue()) {
                    this.setLiteralValueInColumn((FieldSource<JavaClassSource>)field, "updatable", "false");
                }
            } else {
                String fieldType = (String)this.type.getValue();
                field = this.beanOperations.addFieldTo(targetEntity, fieldType, fieldNameStr, new String[]{Column.class.getCanonicalName()});
            }
            if (this.length.isEnabled() && this.length.getValue() != null && (Integer)this.length.getValue() != 255) {
                this.setLiteralValueInColumn((FieldSource<JavaClassSource>)field, "length", String.valueOf(this.length.getValue()));
            }
            if (this.columnName.isEnabled() && this.columnName.hasValue()) {
                field.getAnnotation(Column.class).setStringValue("name", (String)this.columnName.getValue());
            }
            if (this.notNullable.isEnabled() && ((Boolean)this.notNullable.getValue()).booleanValue()) {
                this.setLiteralValueInColumn((FieldSource<JavaClassSource>)field, "nullable", "false");
            }
            if (this.notInsertable.isEnabled() && ((Boolean)this.notInsertable.getValue()).booleanValue()) {
                this.setLiteralValueInColumn((FieldSource<JavaClassSource>)field, "insertable", "false");
            }
            if (this.notUpdatable.isEnabled() && ((Boolean)this.notUpdatable.getValue()).booleanValue()) {
                this.setLiteralValueInColumn((FieldSource<JavaClassSource>)field, "updatable", "false");
            }
            if (this.temporalType.isEnabled()) {
                field.addAnnotation(Temporal.class).setEnumValue(new Enum[]{(Enum)this.temporalType.getValue()});
            }
            this.setCurrentWorkingResource(context, javaResource, (Field<JavaClassSource>)field);
            return Results.success((String)("Field " + (String)this.named.getValue() + " " + action));
        }
        return Results.success();
    }

    private void setLiteralValueInColumn(FieldSource<JavaClassSource> field, String literal, String value) {
        if (field.getAnnotation(Column.class) != null) {
            field.getAnnotation(Column.class).setLiteralValue(literal, value);
        }
    }

    private void setCurrentWorkingResource(UIExecutionContext context, JavaResource javaResource, Field<JavaClassSource> field) throws FileNotFoundException {
        Project selectedProject = this.getSelectedProject((UIContextProvider)context);
        if (selectedProject != null) {
            JavaSourceFacet facet = (JavaSourceFacet)selectedProject.getFacet(JavaSourceFacet.class);
            facet.saveJavaSource((JavaSource)field.getOrigin());
        }
        context.getUIContext().setSelection((Object)javaResource);
    }

    public void validate(UIValidationContext validator) {
        super.validate(validator);
        try {
            JavaClassSource javaClass;
            JavaResource javaResource = (JavaResource)this.targetEntity.getValue();
            if (javaResource != null && (javaClass = (JavaClassSource)javaResource.getJavaType()).hasField((String)this.named.getValue())) {
                validator.addValidationWarning(this.targetEntity, "Field '" + (String)this.named.getValue() + "' already exists");
            }
        }
        catch (FileNotFoundException ffe) {
            validator.addValidationError(this.targetEntity, "Entity could not be found");
        }
        if (this.length.isEnabled() && (this.length.getValue() == null || (Integer)this.length.getValue() <= 0)) {
            validator.addValidationError(this.length, "Length should be a positive integer");
        }
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        Map attributeMap = context.getUIContext().getAttributeMap();
        attributeMap.put(JavaResource.class, this.targetEntity.getValue());
        attributeMap.put("fieldName", this.named.getValue());
        attributeMap.put("fieldType", this.type.getValue());
        attributeMap.put(RelationshipType.class, this.relationshipType.getValue());
        if (this.relationshipType.getValue() == RelationshipType.BASIC) {
            return null;
        }
        return Results.navigateTo(JPANewFieldRelationshipWizardStep.class);
    }

    protected boolean isProjectRequired() {
        return true;
    }

    public NavigationResult getPrerequisiteCommands(UIContext context) {
        NavigationResultBuilder builder = NavigationResultBuilder.create();
        Project project = this.getSelectedProject(context);
        if (project != null && !project.hasFacet(JPAFacet.class)) {
            builder.add(JPASetupWizard.class);
        }
        return builder.build();
    }
}

