/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa.ui;

import java.util.List;
import javax.inject.Inject;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.javaee.jpa.JPAFacet;
import org.jboss.forge.addon.javaee.jpa.PersistenceOperations;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;

@FacetConstraint(value={JPAFacet.class})
public class JPANewNamedQueryCommand
extends AbstractJavaEECommand {
    @Inject
    @WithAttributes(label="Query Name", description="The name attribute of the @NamedQuery annotation", required=true)
    private UIInput<String> named;
    @Inject
    @WithAttributes(label="Query", description="The query attribute of the @NamedQuery annotation", required=true)
    private UIInput<String> query;
    @Inject
    @WithAttributes(label="Target Entity", required=true, type="org.jboss.forge.inputType.DROPDOWN")
    private UISelectOne<JavaResource> targetEntity;
    @Inject
    private PersistenceOperations persistenceOperations;

    public void initializeUI(UIBuilder builder) throws Exception {
        UIContext context = builder.getUIContext();
        UISelection selection = context.getInitialSelection();
        Project project = this.getSelectedProject((UIContextProvider)builder);
        List entities = this.persistenceOperations.getProjectEntities(project);
        this.targetEntity.setValueChoices((Iterable)entities);
        int idx = -1;
        if (!selection.isEmpty()) {
            idx = entities.indexOf(selection.get());
        }
        if (idx != -1) {
            this.targetEntity.setDefaultValue(entities.get(idx));
        }
        builder.add(this.named).add(this.query).add(this.targetEntity);
    }

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("JPA: New Named Query").description("Creates a @NamedQuery in a JPA Entity").category(Categories.create((String[])new String[]{super.getMetadata(context).getCategory().getName(), "JPA"}));
    }

    public Result execute(UIExecutionContext context) throws Exception {
        String queryName = (String)this.named.getValue();
        String queryValue = (String)this.query.getValue();
        JavaResource entity = (JavaResource)this.targetEntity.getValue();
        JavaClassSource javaClass = (JavaClassSource)entity.getJavaType();
        AnnotationSource namedQueriesAnn = javaClass.hasAnnotation(NamedQueries.class) ? javaClass.getAnnotation(NamedQueries.class) : javaClass.addAnnotation(NamedQueries.class);
        AnnotationSource namedQuery = null;
        if (namedQueriesAnn.getAnnotationArrayValue() != null) {
            for (AnnotationSource namedQueryItem : namedQueriesAnn.getAnnotationArrayValue()) {
                if (!queryName.equals(namedQueryItem.getStringValue("name"))) continue;
                namedQuery = namedQueryItem;
                break;
            }
        }
        if (namedQuery == null) {
            namedQuery = namedQueriesAnn.addAnnotationValue(NamedQuery.class);
            namedQuery.setStringValue("name", queryName);
        }
        namedQuery.setStringValue("query", queryValue);
        entity.setContents((JavaSource)javaClass);
        return Results.success((String)("Named query " + queryName + " was created."));
    }

    protected boolean isProjectRequired() {
        return true;
    }
}

