/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa.ui.setup;

import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.javaee.jpa.DatabaseType;
import org.jboss.forge.addon.javaee.jpa.JPADataSource;
import org.jboss.forge.addon.javaee.jpa.PersistenceContainer;
import org.jboss.forge.addon.javaee.jpa.PersistenceOperations;
import org.jboss.forge.addon.javaee.jpa.PersistenceProvider;
import org.jboss.forge.addon.javaee.jpa.SchemaGenerationType;
import org.jboss.forge.addon.javaee.jpa.containers.JavaEEDefaultContainer;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;

public class JPASetupConnectionStep
extends AbstractJavaEECommand
implements UIWizardStep {
    @Inject
    @WithAttributes(shortName=116, label="Database Type", required=true)
    private UISelectOne<DatabaseType> dbType;
    @Inject
    @WithAttributes(shortName=100, label="DataSource Name", required=true)
    private UIInput<String> dataSourceName;
    @Inject
    @WithAttributes(label="JDBC Driver", required=true, type="org.jboss.forge.inputType.JAVA_CLASS_PICKER")
    private UIInput<String> jdbcDriver;
    @Inject
    @WithAttributes(label="Database URL", required=true)
    private UIInput<String> databaseURL;
    @Inject
    @WithAttributes(label="Username", required=true)
    private UIInput<String> username;
    @Inject
    @WithAttributes(label="Password", type="org.jboss.forge.inputType.SECRET")
    private UIInput<String> password;
    @Inject
    @WithAttributes(label="Persistence Unit Name", required=true)
    private UIInput<String> persistenceUnitName;
    @Inject
    @WithAttributes(label="Overwrite Persistence Unit")
    private UIInput<Boolean> overwritePersistenceUnit;
    @Inject
    private PersistenceOperations persistenceOperations;
    @Inject
    @WithAttributes(label="Schema Generation Type", shortName=115, required=true, type="org.jboss.forge.inputType.RADIO")
    private UISelectOne<SchemaGenerationType> schemaGenerationType;

    public NavigationResult next(UINavigationContext context) throws Exception {
        return null;
    }

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("JPA: Connection Settings").description("Configure your connection settings");
    }

    public boolean isEnabled(UIContext context) {
        return true;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        final UIContext uiContext = builder.getUIContext();
        PersistenceContainer pc = (PersistenceContainer)uiContext.getAttributeMap().get(PersistenceContainer.class);
        this.initDBType(uiContext);
        this.initDatasourceName(uiContext);
        this.initPersistenceUnitName(builder);
        builder.add(this.dbType);
        this.overwritePersistenceUnit.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Project project = JPASetupConnectionStep.this.getSelectedProject(uiContext);
                if (JPASetupConnectionStep.this.persistenceUnitName.getValue() == null) {
                    return false;
                }
                return JPASetupConnectionStep.this.isExistingPersistenceUnitName(project, (String)JPASetupConnectionStep.this.persistenceUnitName.getValue());
            }
        });
        builder.add(this.overwritePersistenceUnit);
        if (pc.isDataSourceRequired()) {
            builder.add(this.dataSourceName);
        } else {
            builder.add(this.jdbcDriver).add(this.databaseURL).add(this.username).add(this.password);
        }
        if (uiContext.getProvider().isGUI()) {
            this.schemaGenerationType.setItemLabelConverter((Converter)new Converter<SchemaGenerationType, String>(){

                public String convert(SchemaGenerationType source) {
                    return source != null ? source.getLabel() : null;
                }
            });
        }
        this.schemaGenerationType.setDefaultValue((Object)SchemaGenerationType.DROP_CREATE);
        this.schemaGenerationType.setDescription((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ((SchemaGenerationType)JPASetupConnectionStep.this.schemaGenerationType.getValue()).getDescription();
            }
        });
        builder.add(this.schemaGenerationType);
    }

    private void initPersistenceUnitName(UIBuilder builder) {
        int i = 1;
        Project selectedProject = this.getSelectedProject(builder.getUIContext());
        String projectName = selectedProject == null ? "forge" : ((MetadataFacet)selectedProject.getFacet(MetadataFacet.class)).getProjectName();
        String unitName = projectName + "-persistence-unit";
        while (this.isExistingPersistenceUnitName(selectedProject, unitName)) {
            unitName = projectName + "-persistence-unit" + "-" + i++;
        }
        builder.add((InputComponent)this.persistenceUnitName.setDefaultValue((Object)unitName));
    }

    private void initDatasourceName(final UIContext uiContext) {
        this.dataSourceName.setDefaultValue((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                PersistenceContainer pc = (PersistenceContainer)uiContext.getAttributeMap().get(PersistenceContainer.class);
                if (pc instanceof JavaEEDefaultContainer) {
                    return ((JavaEEDefaultContainer)pc).getDefaultDataSource();
                }
                return null;
            }
        });
    }

    private void initDBType(final UIContext uiContext) {
        this.dbType.setDefaultValue((Callable)new Callable<DatabaseType>(){

            @Override
            public DatabaseType call() throws Exception {
                DatabaseType type = DatabaseType.DEFAULT;
                PersistenceContainer pc = (PersistenceContainer)uiContext.getAttributeMap().get(PersistenceContainer.class);
                if (pc instanceof JavaEEDefaultContainer) {
                    type = ((JavaEEDefaultContainer)pc).getDefaultDatabaseType();
                }
                return type;
            }
        });
    }

    private JPADataSource getDataSource(UIContext context) {
        JPADataSource dataSource = new JPADataSource();
        dataSource.setDatabase((DatabaseType)this.dbType.getValue());
        dataSource.setJndiDataSource((String)this.dataSourceName.getValue());
        dataSource.setDatabaseURL((String)this.databaseURL.getValue());
        dataSource.setUsername((String)this.username.getValue());
        dataSource.setPassword((String)this.password.getValue());
        dataSource.setSchemaGenerationType((SchemaGenerationType)this.schemaGenerationType.getValue());
        Map attributeMap = context.getAttributeMap();
        dataSource.setProvider((PersistenceProvider)attributeMap.get(PersistenceProvider.class));
        dataSource.setContainer((PersistenceContainer)attributeMap.get(PersistenceContainer.class));
        return dataSource;
    }

    public void validate(UIValidationContext validator) {
        UIContext uiContext = validator.getUIContext();
        JPADataSource ds = this.getDataSource(uiContext);
        try {
            ds.validate();
        }
        catch (Exception e) {
            validator.addValidationError(null, e.getMessage());
        }
        Project project = this.getSelectedProject(uiContext);
        if (this.isExistingPersistenceUnitName(project, (String)this.persistenceUnitName.getValue()) && !((Boolean)this.overwritePersistenceUnit.getValue()).booleanValue()) {
            boolean gui = uiContext.getProvider().isGUI();
            String info = gui ? " Check 'Overwrite Persistence Unit' if you want to overwrite it." : " Use '--overwritePersistenceUnit' if you want to overwrite it.";
            validator.addValidationError(this.persistenceUnitName, "A persistence-unit with the name [" + (String)this.persistenceUnitName.getValue() + "] already exists." + info);
        }
    }

    private boolean isExistingPersistenceUnitName(Project project, String unitName) {
        return this.persistenceOperations.getExistingPersistenceUnit(project, unitName) != null;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        UIContext uiContext = context.getUIContext();
        Project project = this.getSelectedProject(uiContext);
        JPADataSource dataSource = this.getDataSource(uiContext);
        Boolean configureMetadata = (Boolean)uiContext.getAttributeMap().get("ConfigureMetadata");
        String puName = (String)this.persistenceUnitName.getValue();
        this.persistenceOperations.setup(puName, project, dataSource, configureMetadata.booleanValue());
        return Results.success((String)"Persistence (JPA) is installed.");
    }

    protected boolean isProjectRequired() {
        return false;
    }
}

