/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.rest;

import org.jboss.forge.addon.javaee.AbstractJavaEEFacet;
import org.jboss.forge.addon.javaee.rest.RestFacet;
import org.jboss.forge.addon.javaee.rest.config.RestConfigurationStrategy;
import org.jboss.forge.addon.javaee.rest.config.RestConfigurationStrategyFactory;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;

public abstract class AbstractRestFacet
extends AbstractJavaEEFacet
implements RestFacet {
    private RestConfigurationStrategy configurationStrategy;

    public AbstractRestFacet(DependencyInstaller installer) {
        super(installer);
    }

    public String getSpecName() {
        return "JAX-RS";
    }

    @Override
    public boolean isInstalled() {
        return super.isInstalled() && this.getConfigurationStrategy() != null;
    }

    @Override
    public boolean install() {
        return super.install();
    }

    public RestConfigurationStrategy getConfigurationStrategy() {
        if (this.configurationStrategy == null) {
            Project project = (Project)this.getFaceted();
            this.configurationStrategy = RestConfigurationStrategyFactory.from((Project)project);
        }
        return this.configurationStrategy;
    }

    public void setConfigurationStrategy(RestConfigurationStrategy strategy) {
        Project project = (Project)this.getFaceted();
        if (this.configurationStrategy != null) {
            this.configurationStrategy.uninstall(project);
        }
        strategy.install(project);
        this.configurationStrategy = strategy;
    }

    public String getApplicationPath() {
        return this.getConfigurationStrategy() != null ? this.getConfigurationStrategy().getApplicationPath() : null;
    }
}

