/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.rest.generator;

import java.util.Iterator;
import java.util.List;
import org.jboss.forge.addon.javaee.jpa.JPAEntityUtil;
import org.jboss.forge.addon.javaee.rest.generation.RestGenerationContext;
import org.jboss.forge.addon.javaee.rest.generator.RestResourceTypeVisitor;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.projects.Project;

public class ResourceGeneratorUtil {
    public static String getResourcePath(RestGenerationContext context) {
        String packageName = context.getTargetPackageName();
        String entityTable = JPAEntityUtil.getEntityTable(context.getEntity());
        Project project = context.getProject();
        String proposedQualifiedClassName = packageName + "." + entityTable + "Endpoint";
        String proposedResourcePath = "/" + context.getInflector().pluralize((Object)entityTable.toLowerCase());
        RestResourceTypeVisitor resourceTypeVisitor = new RestResourceTypeVisitor();
        resourceTypeVisitor.setFound(false);
        resourceTypeVisitor.setProposedPath(proposedResourcePath);
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        while (true) {
            facet.visitJavaSources((JavaResourceVisitor)resourceTypeVisitor);
            if (!resourceTypeVisitor.isFound() || proposedQualifiedClassName.equals(resourceTypeVisitor.getQualifiedClassNameForMatch())) break;
            proposedResourcePath = proposedResourcePath.startsWith("/") ? "forge" + proposedResourcePath : "forge/" + proposedResourcePath;
            resourceTypeVisitor.setProposedPath(proposedResourcePath);
            resourceTypeVisitor.setFound(false);
        }
        return proposedResourcePath;
    }

    public static String getContentType(List<String> contentType) {
        StringBuilder contentTypeBuilder = new StringBuilder();
        if (contentType.size() > 1) {
            contentTypeBuilder.append("{");
            Iterator<String> iter = contentType.iterator();
            while (iter.hasNext()) {
                contentTypeBuilder.append('\"').append(iter.next()).append('\"');
                if (!iter.hasNext()) continue;
                contentTypeBuilder.append(',');
            }
            contentTypeBuilder.append("}");
        } else {
            String contentTypeValue = contentType.get(0);
            contentTypeBuilder.append('\"').append(contentTypeValue).append('\"');
        }
        return contentTypeBuilder.toString();
    }
}

